/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.experimentautomation.application.VariationFactorTuple;
import org.palladiosimulator.experimentautomation.application.utils.EcoreHelper;
import org.palladiosimulator.experimentautomation.application.variation.IVariationStrategy;
import org.palladiosimulator.experimentautomation.application.variation.VariationStrategyFactory;

public class VaryJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private final List<VariationFactorTuple> variationFactorTuples;

    public VaryJob(List<VariationFactorTuple> variationFactorTuples) {
        super(false);
        this.variationFactorTuples = variationFactorTuples;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        for (VariationFactorTuple variationAndFactor : this.variationFactorTuples) {
            this.executeVariation(variationAndFactor);
        }
    }

    private void executeVariation(VariationFactorTuple variationAndFactor) {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        EObject variedObject = EcoreHelper.findModelElementById(pcmPartition.getResourceSet(), variationAndFactor.getVariation().getVariedObjectId());
        if (variedObject == null) {
            throw new RuntimeException("Unable to find model element with ID " + variationAndFactor.getVariation().getVariedObjectId() + " in resource set");
        }
        IVariationStrategy variationStrategy = VariationStrategyFactory.createStrategy(variationAndFactor.getVariation().getType());
        variationStrategy.setVariedObject(variedObject);
        variationStrategy.vary(variationAndFactor.getFactor());
    }
}

