/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.utils;

import de.uka.ipd.sdq.identifier.Identifier;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;

public class EcoreHelper {
    private static final Logger LOGGER = Logger.getLogger(EcoreHelper.class);

    public static <T extends EObject> T copy(T source) {
        EObject copy = EcoreUtil.copy(source);
        EcoreHelper.createNewIds(copy);
        return (T)copy;
    }

    private static <T extends EObject> void createNewIds(T source) {
        if (Identifier.class.isInstance(source)) {
            ((Identifier)source).setId(EcoreUtil.generateUUID());
        }
        EList contents = source.eContents();
        for (EObject o : contents) {
            EcoreHelper.createNewIds(o);
        }
    }

    public static EObject findModelElementById(ResourceSet resourceSet, String id) {
        for (Resource resource : resourceSet.getResources()) {
            EObject eObject = resource.getEObject(id);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }

    public static <T extends EClass> EObject loadResourceFromBundle(ResourceSet resourceSet, Bundle bundle, IPath modelLocation, T expectedType) {
        LOGGER.info((Object)("Loading resource " + modelLocation.toString() + " from bundle"));
        URI modelUri = URI.createFileURI((String)modelLocation.toOSString());
        Resource r = resourceSet.getResource(modelUri, true);
        EObject o = (EObject)r.getContents().get(0);
        if (expectedType.isInstance((Object)o)) {
            return o;
        }
        throw new RuntimeException("The root element of the loaded resource is not of the expected type " + expectedType.getName());
    }
}

