/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.dictionary.characterized.dsl.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;

public class CharacterizedDataDictionaryGenerator
extends AbstractGenerator {
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            this.createXMIVersionOfResource(resource, fsa);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void createXMIVersionOfResource(Resource resource, IFileSystemAccess2 fsa) throws IOException {
        URI tmpUri = resource.getURI().trimSegments(1).appendSegment(String.valueOf(UUID.randomUUID().toString()) + ".xmi");
        Resource tmpResource = resource.getResourceSet().createResource(tmpUri);
        try {
            tmpResource.getContents().addAll((Collection)resource.getContents().stream().map(EcoreUtil::copy).collect(Collectors.toList()));
            ByteArrayOutputStream tmpOutput = new ByteArrayOutputStream();
            tmpResource.save((OutputStream)tmpOutput, Collections.emptyMap());
            String fileName = String.valueOf(resource.getURI().trimFileExtension().lastSegment()) + ".xmi";
            fsa.generateFile(fileName, (CharSequence)tmpOutput.toString());
        }
        finally {
            tmpResource.delete(Collections.emptyMap());
        }
    }
}

