/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.dictionary.characterized.dsl.service;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class XPathConstructor {
    public String getId(EObject eobject, String baseId) {
        String constructedIndex = this.getIndexBasedSuffix(eobject);
        if (Strings.isNullOrEmpty((String)constructedIndex)) {
            return baseId;
        }
        return String.valueOf(baseId) + "-" + constructedIndex;
    }

    protected String getIndexBasedSuffix(EObject object) {
        ArrayList<String> segments = new ArrayList<String>();
        EObject current = object;
        while (current.eContainer() != null) {
            int index = this.getIndexInContainment(current);
            String name = this.getContainmentName(current);
            segments.add(String.valueOf(name) + "@" + index);
            current = current.eContainer();
        }
        Collections.reverse(segments);
        return segments.stream().collect(Collectors.joining("."));
    }

    protected int getIndexInContainment(EObject object) {
        EReference containmentReference = object.eContainmentFeature();
        Object containmentContent = object.eContainer().eGet((EStructuralFeature)containmentReference);
        return Optional.ofNullable(containmentContent).filter(List.class::isInstance).map(List.class::cast).map(c -> c.indexOf(object)).orElse(0);
    }

    protected String getContainmentName(EObject object) {
        return object.eContainmentFeature().getName();
    }
}

