/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.expressions.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ArithmeticOperator implements Enumerator
{
    PLUS(0, "PLUS", "PLUS"),
    MINUS(1, "MINUS", "MINUS"),
    TIMES(2, "TIMES", "TIMES"),
    DIVIDE(3, "DIVIDE", "DIVIDE"),
    MODULO(4, "MODULO", "MODULO");

    public static final int PLUS_VALUE = 0;
    public static final int MINUS_VALUE = 1;
    public static final int TIMES_VALUE = 2;
    public static final int DIVIDE_VALUE = 3;
    public static final int MODULO_VALUE = 4;
    private static final ArithmeticOperator[] VALUES_ARRAY;
    public static final List<ArithmeticOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ArithmeticOperator[]{PLUS, MINUS, TIMES, DIVIDE, MODULO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ArithmeticOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArithmeticOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArithmeticOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArithmeticOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArithmeticOperator get(int value) {
        switch (value) {
            case 0: {
                return PLUS;
            }
            case 1: {
                return MINUS;
            }
            case 2: {
                return TIMES;
            }
            case 3: {
                return DIVIDE;
            }
            case 4: {
                return MODULO;
            }
        }
        return null;
    }

    private ArithmeticOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

