/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.expressions.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LogicOperator implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR"),
    IMPLY(3, "IMPLY", "IMPLY"),
    EQUIVALENT(4, "EQUIVALENT", "EQUIVALENT");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int IMPLY_VALUE = 3;
    public static final int EQUIVALENT_VALUE = 4;
    private static final LogicOperator[] VALUES_ARRAY;
    public static final List<LogicOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicOperator[]{AND, OR, XOR, IMPLY, EQUIVALENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return IMPLY;
            }
            case 4: {
                return EQUIVALENT;
            }
        }
        return null;
    }

    private LogicOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

