/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.expressions.common.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.ArithmeticOperator;
import org.storydriven.core.expressions.common.CommonExpressionsFactory;
import org.storydriven.core.expressions.common.CommonExpressionsPackage;
import org.storydriven.core.expressions.common.ComparingOperator;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.core.expressions.common.LogicOperator;
import org.storydriven.core.expressions.common.LogicalExpression;
import org.storydriven.core.expressions.common.UnaryExpression;
import org.storydriven.core.expressions.common.UnaryOperator;
import org.storydriven.core.expressions.common.impl.ArithmeticExpressionImpl;
import org.storydriven.core.expressions.common.impl.ComparisonExpressionImpl;
import org.storydriven.core.expressions.common.impl.LiteralExpressionImpl;
import org.storydriven.core.expressions.common.impl.LogicalExpressionImpl;
import org.storydriven.core.expressions.common.impl.UnaryExpressionImpl;

public class CommonExpressionsFactoryImpl
extends EFactoryImpl
implements CommonExpressionsFactory {
    public static CommonExpressionsFactory init() {
        try {
            CommonExpressionsFactory theCommonExpressionsFactory = (CommonExpressionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.storydriven.org/core/expressions/common/0.3.1");
            if (theCommonExpressionsFactory != null) {
                return theCommonExpressionsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonExpressionsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createUnaryExpression();
            }
            case 2: {
                return this.createComparisonExpression();
            }
            case 3: {
                return this.createArithmeticExpression();
            }
            case 4: {
                return this.createLogicalExpression();
            }
            case 5: {
                return this.createLiteralExpression();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createLogicOperatorFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createComparingOperatorFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createArithmeticOperatorFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createUnaryOperatorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertLogicOperatorToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertComparingOperatorToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertArithmeticOperatorToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertUnaryOperatorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public UnaryExpression createUnaryExpression() {
        UnaryExpressionImpl unaryExpression = new UnaryExpressionImpl();
        return unaryExpression;
    }

    @Override
    public ComparisonExpression createComparisonExpression() {
        ComparisonExpressionImpl comparisonExpression = new ComparisonExpressionImpl();
        return comparisonExpression;
    }

    @Override
    public ArithmeticExpression createArithmeticExpression() {
        ArithmeticExpressionImpl arithmeticExpression = new ArithmeticExpressionImpl();
        return arithmeticExpression;
    }

    @Override
    public LogicalExpression createLogicalExpression() {
        LogicalExpressionImpl logicalExpression = new LogicalExpressionImpl();
        return logicalExpression;
    }

    @Override
    public LiteralExpression createLiteralExpression() {
        LiteralExpressionImpl literalExpression = new LiteralExpressionImpl();
        return literalExpression;
    }

    public LogicOperator createLogicOperatorFromString(EDataType eDataType, String initialValue) {
        LogicOperator result = LogicOperator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLogicOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ComparingOperator createComparingOperatorFromString(EDataType eDataType, String initialValue) {
        ComparingOperator result = ComparingOperator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertComparingOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ArithmeticOperator createArithmeticOperatorFromString(EDataType eDataType, String initialValue) {
        ArithmeticOperator result = ArithmeticOperator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertArithmeticOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public UnaryOperator createUnaryOperatorFromString(EDataType eDataType, String initialValue) {
        UnaryOperator result = UnaryOperator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertUnaryOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CommonExpressionsPackage getCommonExpressionsPackage() {
        return (CommonExpressionsPackage)this.getEPackage();
    }

    @Deprecated
    public static CommonExpressionsPackage getPackage() {
        return CommonExpressionsPackage.eINSTANCE;
    }
}

