/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.expressions.pathExpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RepeatOperator implements Enumerator
{
    NO_REPEAT(0, "NO_REPEAT", "NO_REPEAT"),
    AT_LEAST_ONCE(1, "AT_LEAST_ONCE", "+"),
    ARBITRARY(2, "ARBITRARY", "*");

    public static final int NO_REPEAT_VALUE = 0;
    public static final int AT_LEAST_ONCE_VALUE = 1;
    public static final int ARBITRARY_VALUE = 2;
    private static final RepeatOperator[] VALUES_ARRAY;
    public static final List<RepeatOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RepeatOperator[]{NO_REPEAT, AT_LEAST_ONCE, ARBITRARY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RepeatOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepeatOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepeatOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepeatOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepeatOperator get(int value) {
        switch (value) {
            case 0: {
                return NO_REPEAT;
            }
            case 1: {
                return AT_LEAST_ONCE;
            }
            case 2: {
                return ARBITRARY;
            }
        }
        return null;
    }

    private RepeatOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

