/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.DataFlowConfidentialityAnalysis;
import org.dataflowanalysis.analysis.pcm.core.PCMFlowGraphCollection;
import org.dataflowanalysis.analysis.pcm.resource.PCMResourceProvider;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.dddsl.DDDslStandaloneSetup;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.DictionaryPackage;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.PCMDataDictionary;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.linking.impl.AbstractCleaningLinker;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersStateProvider;
import tools.mdsd.library.standalone.initialization.StandaloneInitializationException;
import tools.mdsd.library.standalone.initialization.StandaloneInitializerBuilder;

public class PCMDataFlowConfidentialityAnalysis
extends DataFlowConfidentialityAnalysis {
    private static final String PLUGIN_PATH = "org.dataflowanalysis.analysis.pcm";
    private final Logger logger;
    protected final PCMResourceProvider resourceProvider;
    protected final String modelProjectName;
    protected final Optional<Class<? extends Plugin>> modelProjectActivator;
    protected List<PCMDataDictionary> dataDictionaries;

    public PCMDataFlowConfidentialityAnalysis(PCMResourceProvider resourceProvider, String modelProjectName, Optional<Class<? extends Plugin>> modelProjectActivator) {
        this.resourceProvider = resourceProvider;
        this.logger = Logger.getLogger(PCMDataFlowConfidentialityAnalysis.class);
        this.modelProjectName = modelProjectName;
        this.modelProjectActivator = modelProjectActivator;
    }

    public PCMFlowGraphCollection findFlowGraphs() {
        return new PCMFlowGraphCollection(this.resourceProvider);
    }

    public void initializeAnalysis() {
        if (!this.initStandaloneAnalysis()) {
            throw new IllegalStateException("Standalone initialization of the data flow analysis failed.");
        }
        this.logger.info((Object)"Successfully initialized standalone data flow analysis.");
        if (!this.loadRequiredModels()) {
            throw new IllegalStateException("Failed loading the required models for the data flow analysis.");
        }
        this.logger.info((Object)"Successfully loaded required models for the data flow analysis.");
    }

    public void setLoggerLevel(Level level) {
        this.logger.setLevel(level);
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(level);
        Logger.getLogger(AbstractInternalAntlrParser.class).setLevel(level);
        Logger.getLogger(DefaultLinkingService.class).setLevel(level);
        Logger.getLogger(ResourceSetBasedAllContainersStateProvider.class).setLevel(level);
        Logger.getLogger(AbstractCleaningLinker.class).setLevel(level);
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    private boolean initStandaloneAnalysis() {
        EcorePlugin.ExtensionProcessor.process(null);
        super.setupLoggers();
        if (!this.initStandalone()) {
            return false;
        }
        this.resourceProvider.setupResources();
        DDDslStandaloneSetup.doSetup();
        return true;
    }

    private boolean initStandalone() {
        try {
            StandaloneInitializerBuilder initializationBuilder = StandaloneInitializerBuilder.builder().registerProjectURI(DataFlowConfidentialityAnalysis.class, "org.dataflowanalysis.analysis").registerProjectURI(PCMDataFlowConfidentialityAnalysis.class, PLUGIN_PATH);
            this.modelProjectActivator.ifPresent(projectActivator -> {
                StandaloneInitializerBuilder standaloneInitializerBuilder2 = initializationBuilder.registerProjectURI(projectActivator, this.modelProjectName);
            });
            initializationBuilder.build().init();
            this.logger.info((Object)"Successfully initialized standalone environment for the data flow analysis.");
            return true;
        }
        catch (StandaloneInitializationException e) {
            this.logger.error((Object)"Unable to initialize standalone environment for the data flow analysis", (Throwable)e);
            return false;
        }
    }

    private boolean loadRequiredModels() {
        try {
            this.resourceProvider.loadRequiredResources();
            this.resourceProvider.validate();
            this.dataDictionaries = this.resourceProvider.lookupToplevelElement(DictionaryPackage.eINSTANCE.getPCMDataDictionary()).stream().filter(PCMDataDictionary.class::isInstance).map(PCMDataDictionary.class::cast).collect(Collectors.toList());
            this.logger.info((Object)String.format("Successfully loaded %d data %s.", this.dataDictionaries.size(), this.dataDictionaries.size() == 1 ? "dictionary" : "dictionaries"));
            return true;
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)"Could not load required models", (Throwable)e);
            return false;
        }
    }
}

