/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm;

import java.nio.file.Paths;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.DataFlowAnalysisBuilder;
import org.dataflowanalysis.analysis.pcm.PCMDataFlowConfidentialityAnalysis;
import org.dataflowanalysis.analysis.pcm.resource.PCMResourceProvider;
import org.dataflowanalysis.analysis.pcm.resource.PCMURIResourceProvider;
import org.dataflowanalysis.analysis.utils.ResourceUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;

public class PCMDataFlowConfidentialityAnalysisBuilder
extends DataFlowAnalysisBuilder {
    private final Logger logger = Logger.getLogger(PCMDataFlowConfidentialityAnalysisBuilder.class);
    protected String relativeUsageModelPath;
    protected String relativeAllocationModelPath;
    protected String relativeNodeCharacteristicsPath;
    protected Optional<PCMResourceProvider> customResourceProvider = Optional.empty();

    public PCMDataFlowConfidentialityAnalysisBuilder usePluginActivator(Class<? extends Plugin> pluginActivator) {
        super.usePluginActivator(pluginActivator);
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder useUsageModel(String relativeUsageModelPath) {
        this.relativeUsageModelPath = relativeUsageModelPath;
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder useAllocationModel(String relativeAllocationModelPath) {
        this.relativeAllocationModelPath = relativeAllocationModelPath;
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder useNodeCharacteristicsModel(String relativeNodeCharacteristicsModelPath) {
        this.relativeNodeCharacteristicsPath = relativeNodeCharacteristicsModelPath;
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder useCustomResourceProvider(PCMResourceProvider resourceProvider) {
        this.customResourceProvider = Optional.of(resourceProvider);
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder standalone() {
        super.standalone();
        return this;
    }

    public PCMDataFlowConfidentialityAnalysisBuilder modelProjectName(String modelProjectName) {
        super.modelProjectName(modelProjectName);
        return this;
    }

    private PCMResourceProvider getEffectiveResourceProvider() {
        return this.customResourceProvider.orElseGet(this::getURIResourceProvider);
    }

    private PCMResourceProvider getURIResourceProvider() {
        URI usageModelUri = this.modelProjectName.isEmpty() ? URI.createFileURI((String)Paths.get(this.relativeUsageModelPath, new String[0]).toAbsolutePath().toString()) : ResourceUtils.createRelativePluginURI((String)this.relativeUsageModelPath, (String)this.modelProjectName);
        URI allocationModelUri = this.modelProjectName.isEmpty() ? URI.createFileURI((String)Paths.get(this.relativeAllocationModelPath, new String[0]).toAbsolutePath().toString()) : ResourceUtils.createRelativePluginURI((String)this.relativeAllocationModelPath, (String)this.modelProjectName);
        URI nodeCharacteristicsUri = this.modelProjectName.isEmpty() ? URI.createFileURI((String)Paths.get(this.relativeNodeCharacteristicsPath, new String[0]).toAbsolutePath().toString()) : ResourceUtils.createRelativePluginURI((String)this.relativeNodeCharacteristicsPath, (String)this.modelProjectName);
        return new PCMURIResourceProvider(usageModelUri, allocationModelUri, nodeCharacteristicsUri);
    }

    protected void validate() {
        super.validate();
        if (this.customResourceProvider.isEmpty() && (this.relativeUsageModelPath == null || this.relativeUsageModelPath.isEmpty())) {
            this.logger.error((Object)"The dataflow analysis requires a path to a usage model", (Throwable)new IllegalStateException("The Analysis requires a usage model"));
        }
        if (this.customResourceProvider.isEmpty() && (this.relativeAllocationModelPath == null || this.relativeAllocationModelPath.isEmpty())) {
            this.logger.error((Object)"The dataflow analysis requires a path to an allocation model", (Throwable)new IllegalStateException("The Analysis requires an allocation model"));
        }
        if (this.customResourceProvider.isPresent()) {
            this.customResourceProvider.get().setupResources();
            this.customResourceProvider.get().loadRequiredResources();
            this.customResourceProvider.get().validate();
            if (!this.customResourceProvider.get().sufficientResourcesLoaded()) {
                this.logger.error((Object)"The custom resource provider could not load all required resources", (Throwable)new IllegalStateException("Could not load all required resources"));
            }
        }
        if (this.customResourceProvider.isEmpty() && (this.relativeNodeCharacteristicsPath == null || this.relativeNodeCharacteristicsPath.isEmpty())) {
            this.logger.warn((Object)"Using node characteristic model without specifying path to the assignment model. No node characteristics will be applied!");
        }
    }

    public PCMDataFlowConfidentialityAnalysis build() {
        this.validate();
        PCMResourceProvider resourceProvider = this.getEffectiveResourceProvider();
        return new PCMDataFlowConfidentialityAnalysis(resourceProvider, this.modelProjectName, this.pluginActivator);
    }
}

