/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core;

import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.PCMDataCharacteristicsCalculator;
import org.dataflowanalysis.analysis.pcm.core.PCMVertexCharacteristicsCalculator;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;

public abstract class AbstractPCMVertex<T extends Entity>
extends AbstractVertex<T> {
    private final Logger logger = Logger.getLogger(AbstractPCMVertex.class);
    protected final Deque<AssemblyContext> context;
    protected final ResourceProvider resourceProvider;
    protected List<? extends AbstractPCMVertex<?>> previousElements;

    public AbstractPCMVertex(T referencedElement, Deque<AssemblyContext> context, ResourceProvider resourceProvider) {
        super(referencedElement);
        this.context = context;
        this.resourceProvider = resourceProvider;
        this.previousElements = List.of();
    }

    public AbstractPCMVertex(T referencedElement, List<? extends AbstractPCMVertex<?>> previousElements, Deque<AssemblyContext> context, ResourceProvider resourceProvider) {
        super(referencedElement);
        this.context = context;
        this.resourceProvider = resourceProvider;
        this.previousElements = previousElements;
    }

    public abstract AbstractPCMVertex<?> copy(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> var1);

    protected void setPropagationResult(List<DataCharacteristic> incomingDataCharacteristics, List<DataCharacteristic> outgoingDataCharacteristics, List<CharacteristicValue> vertexCharacteristics) {
        super.setPropagationResult(incomingDataCharacteristics, outgoingDataCharacteristics, vertexCharacteristics);
    }

    public List<? extends AbstractPCMVertex<?>> getPreviousElements() {
        return this.previousElements;
    }

    public void setPreviousElements(List<? extends AbstractPCMVertex<?>> previousElements) {
        this.previousElements = previousElements;
    }

    protected List<DataCharacteristic> getIncomingDataCharacteristics() {
        if (super.isSource()) {
            return List.of();
        }
        this.getPreviousElements().stream().filter(it -> !it.isEvaluated()).forEach(AbstractVertex::evaluateDataFlow);
        return this.getPreviousElements().stream().flatMap(it -> it.getAllOutgoingDataCharacteristics().stream()).collect(Collectors.toList());
    }

    protected List<CharacteristicValue> getVertexCharacteristics() {
        PCMVertexCharacteristicsCalculator vertexCharacteristicsCalculator = new PCMVertexCharacteristicsCalculator(this.resourceProvider);
        return vertexCharacteristicsCalculator.getVertexCharacteristics((Entity)this.referencedElement, this.context);
    }

    protected List<DataCharacteristic> getDataCharacteristics(List<CharacteristicValue> vertexCharacteristics, List<ConfidentialityVariableCharacterisation> variableCharacterisations, List<DataCharacteristic> oldDataCharacteristics) {
        PCMDataCharacteristicsCalculator dataCharacteristicsCalculator = new PCMDataCharacteristicsCalculator(oldDataCharacteristics, vertexCharacteristics, this.resourceProvider);
        variableCharacterisations.forEach(dataCharacteristicsCalculator::evaluate);
        return dataCharacteristicsCalculator.getCalculatedCharacteristics();
    }

    protected void checkCallParameter(OperationSignature callSignature, List<ConfidentialityVariableCharacterisation> variableCharacterisations) {
        List<String> parameter = callSignature.getParameters__OperationSignature().stream().map(Parameter::getParameterName).toList();
        List<String> referencedParameter = variableCharacterisations.stream().map(it -> it.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage().getReferenceName()).toList();
        referencedParameter.stream().filter(it -> !parameter.contains(it)).forEach(it -> {
            this.logger.warn((Object)("Unknown reference to variable " + it + " in variable characterisation in vertex " + String.valueOf(this.referencedElement)));
            this.logger.warn((Object)("Present variables:" + String.valueOf(parameter) + ", Referenced parameter: " + String.valueOf(referencedParameter)));
        });
    }

    protected AbstractPCMVertex<?> updateCopy(AbstractPCMVertex<?> copy, Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        if (this.isEvaluated()) {
            copy.setPropagationResult(this.getAllIncomingDataCharacteristics(), this.getAllOutgoingDataCharacteristics(), this.getVertexCharacteristics());
        }
        vertexMapping.put(this, copy);
        List<AbstractPCMVertex> clonedPreviousElements = this.previousElements.stream().map(it -> it.copy(vertexMapping)).toList();
        copy.setPreviousElements(clonedPreviousElements);
        return copy;
    }

    public T getReferencedElement() {
        return (T)((Entity)this.referencedElement);
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public Deque<AssemblyContext> getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEquivalentInContext(Object otherVertexObject) {
        void otherVertex;
        if (!(otherVertexObject instanceof AbstractPCMVertex)) {
            return false;
        }
        AbstractPCMVertex abstractPCMVertex = (AbstractPCMVertex)((Object)otherVertexObject);
        return this.getReferencedElement().getId().equals(otherVertex.getReferencedElement().getId());
    }

    public int hashCode() {
        return Objects.hash(this.getReferencedElement().getId());
    }
}

