/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.PCMCharacteristicValue;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.Entity;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.And;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.False;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.Or;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.Term;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.True;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.DictionaryPackage;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.PCMDataDictionary;
import org.dataflowanalysis.pcm.extension.model.confidentiality.expression.LhsEnumCharacteristicReference;
import org.dataflowanalysis.pcm.extension.model.confidentiality.expression.NamedEnumCharacteristicReference;

public class PCMDataCharacteristicsCalculator {
    private final List<DataCharacteristic> currentVariables;
    private final ResourceProvider resourceLoader;

    public PCMDataCharacteristicsCalculator(List<DataCharacteristic> initialCharacteristics, List<CharacteristicValue> nodeCharacteristics, ResourceProvider resourceProvider) {
        this.currentVariables = new ArrayList<DataCharacteristic>(initialCharacteristics);
        this.resourceLoader = resourceProvider;
        this.createNodeCharacteristicsContainer(nodeCharacteristics);
    }

    private void createNodeCharacteristicsContainer(List<CharacteristicValue> vertexCharacteristics) {
        DataCharacteristic vertexCharacteristicsContainer = new DataCharacteristic("container");
        vertexCharacteristics.forEach(arg_0 -> ((DataCharacteristic)vertexCharacteristicsContainer).addCharacteristic(arg_0));
        this.currentVariables.add(vertexCharacteristicsContainer);
    }

    public void evaluate(ConfidentialityVariableCharacterisation variableCharacterisation) {
        LhsEnumCharacteristicReference leftHandSide = (LhsEnumCharacteristicReference)variableCharacterisation.getLhs();
        EnumCharacteristicType characteristicType = (EnumCharacteristicType)leftHandSide.getCharacteristicType();
        Literal characteristicValue = leftHandSide.getLiteral();
        Term rightHandSide = variableCharacterisation.getRhs();
        AbstractNamedReference reference = variableCharacterisation.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage();
        DataCharacteristic existingCharacteristic = this.getDataCharacteristicByReference(reference).orElse(new DataCharacteristic(reference.getReferenceName()));
        List<CharacteristicValue> modifiedCharacteristics = this.calculateModifiedCharacteristics(existingCharacteristic, characteristicType, characteristicValue);
        DataCharacteristic modifiedVariable = this.createModifiedDataCharacteristic(existingCharacteristic, modifiedCharacteristics, rightHandSide);
        this.currentVariables.remove(existingCharacteristic);
        this.currentVariables.add(modifiedVariable);
    }

    private Optional<DataCharacteristic> getDataCharacteristicByReference(AbstractNamedReference reference) {
        String variableName = reference.getReferenceName();
        return this.currentVariables.stream().filter(it -> it.variableName().equals(variableName)).findAny();
    }

    private DataCharacteristic createModifiedDataCharacteristic(DataCharacteristic existingCharacteristic, List<CharacteristicValue> modifiedCharacteristics, Term rightHandSide) {
        DataCharacteristic computedVariable = new DataCharacteristic(existingCharacteristic.variableName());
        List<CharacteristicValue> unmodifiedCharacteristics = existingCharacteristic.getAllCharacteristics().stream().filter(it -> !modifiedCharacteristics.contains(it)).toList();
        for (CharacteristicValue unmodifiedCharacteristic : unmodifiedCharacteristics) {
            computedVariable = computedVariable.addCharacteristic(unmodifiedCharacteristic);
        }
        for (CharacteristicValue modifiedCharacteristic : modifiedCharacteristics) {
            List<CharacteristicValue> modifiedCharacteristicValues;
            if (!this.evaluateTerm(rightHandSide, modifiedCharacteristic) || !(modifiedCharacteristicValues = computedVariable.getAllCharacteristics().stream().filter(it -> it.getTypeName().equals(modifiedCharacteristic.getTypeName())).toList()).stream().noneMatch(it -> it.getValueName().equals(modifiedCharacteristic.getValueName()))) continue;
            computedVariable = computedVariable.addCharacteristic(modifiedCharacteristic);
        }
        return computedVariable;
    }

    private List<CharacteristicValue> calculateModifiedCharacteristics(DataCharacteristic existingCharacteristic, EnumCharacteristicType characteristicType, Literal characteristicValue) {
        if (characteristicValue == null && characteristicType != null) {
            return this.discoverNewVariables(existingCharacteristic, Optional.of(characteristicType));
        }
        if (characteristicValue == null) {
            return this.discoverNewVariables(existingCharacteristic, Optional.empty());
        }
        return List.of(existingCharacteristic.getAllCharacteristics().stream().filter(it -> it.getValueName().equals(characteristicValue.getName())).filter(it -> it.getTypeName().equals(characteristicType.getName())).findAny().orElse(new PCMCharacteristicValue(characteristicType, characteristicValue)));
    }

    private boolean evaluateTerm(Term term, CharacteristicValue characteristicValue) {
        if (term instanceof True) {
            return true;
        }
        if (term instanceof False) {
            return false;
        }
        if (term instanceof NamedEnumCharacteristicReference) {
            return this.evaluateNamedReference((NamedEnumCharacteristicReference)term, characteristicValue);
        }
        if (term instanceof And) {
            And andTerm = (And)term;
            return this.evaluateTerm(andTerm.getLeft(), characteristicValue) && this.evaluateTerm(andTerm.getRight(), characteristicValue);
        }
        if (term instanceof Or) {
            Or orTerm = (Or)term;
            return this.evaluateTerm(orTerm.getLeft(), characteristicValue) || this.evaluateTerm(orTerm.getRight(), characteristicValue);
        }
        throw new IllegalArgumentException("Unknown type: " + term.getClass().getName());
    }

    private boolean evaluateNamedReference(NamedEnumCharacteristicReference characteristicReference, CharacteristicValue characteristicValue) {
        Optional<DataCharacteristic> optionalDataCharacteristic = this.getDataCharacteristicByReference(characteristicReference.getNamedReference());
        if (optionalDataCharacteristic.isEmpty()) {
            return false;
        }
        DataCharacteristic dataCharacteristic = optionalDataCharacteristic.get();
        String characteristicReferenceTypeName = characteristicReference.getCharacteristicType() != null ? characteristicReference.getCharacteristicType().getName() : characteristicValue.getTypeName();
        String characteristicReferenceValueName = characteristicReference.getLiteral() != null ? characteristicReference.getLiteral().getName() : characteristicValue.getValueName();
        Optional<CharacteristicValue> characteristic = dataCharacteristic.getAllCharacteristics().stream().filter(it -> it.getTypeName().equals(characteristicReferenceTypeName)).filter(it -> it.getValueName().equals(characteristicReferenceValueName)).findAny();
        return characteristic.isPresent() && dataCharacteristic.hasCharacteristic(characteristic.get());
    }

    private List<CharacteristicValue> discoverNewVariables(DataCharacteristic characteristic, Optional<EnumCharacteristicType> characteristicType) {
        ArrayList<CharacteristicValue> updatedCharacteristicValues = new ArrayList<CharacteristicValue>();
        List<PCMDataDictionary> dataDictionaries = this.resourceLoader.lookupToplevelElement(DictionaryPackage.eINSTANCE.getPCMDataDictionary()).stream().filter(PCMDataDictionary.class::isInstance).map(PCMDataDictionary.class::cast).toList();
        List characteristicTypes = dataDictionaries.stream().flatMap(it -> it.getCharacteristicTypes().stream()).filter(it -> characteristicType.isEmpty() || it.getName().equals(((EnumCharacteristicType)characteristicType.get()).getName())).filter(EnumCharacteristicType.class::isInstance).map(EnumCharacteristicType.class::cast).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EnumCharacteristicType>(Comparator.comparing(Entity::getName))), ArrayList::new));
        characteristicTypes.forEach(enumCharacteristicType -> enumCharacteristicType.getType().getLiterals().forEach(characteristicValue -> {
            boolean bl = updatedCharacteristicValues.add(new PCMCharacteristicValue((EnumCharacteristicType)enumCharacteristicType, (Literal)characteristicValue));
        }));
        return updatedCharacteristicValues;
    }

    public List<DataCharacteristic> getCalculatedCharacteristics() {
        return this.currentVariables.stream().filter(df -> !df.variableName().equals("container")).collect(Collectors.toList());
    }
}

