/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.pcm.core.finder.PCMTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.resource.PCMResourceProvider;
import org.dataflowanalysis.analysis.resource.ResourceProvider;

public class PCMFlowGraphCollection
extends FlowGraphCollection {
    private static final Logger logger = Logger.getLogger(PCMFlowGraphCollection.class);

    public PCMFlowGraphCollection() {
    }

    public void initialize(ResourceProvider resourceProvider) {
        super.initialize(resourceProvider);
    }

    public PCMFlowGraphCollection(PCMResourceProvider resourceProvider) {
        super((ResourceProvider)resourceProvider);
    }

    public PCMFlowGraphCollection(List<? extends AbstractTransposeFlowGraph> transposeFlowGraphs, ResourceProvider resourceProvider) {
        super(transposeFlowGraphs, resourceProvider);
    }

    /*
     * WARNING - void declaration
     */
    public List<? extends AbstractTransposeFlowGraph> findTransposeFlowGraphs() {
        void pcmResourceProvider;
        ResourceProvider resourceProvider = this.resourceProvider;
        if (!(resourceProvider instanceof PCMResourceProvider)) {
            logger.error((Object)"Cannot find transpose flow graphs from non-pcm resource provider");
            throw new IllegalArgumentException("Cannot find transpose flow graphs with non-pcm resource provider");
        }
        PCMResourceProvider pCMResourceProvider = (PCMResourceProvider)resourceProvider;
        PCMTransposeFlowGraphFinder sequenceFinder = new PCMTransposeFlowGraphFinder((ResourceProvider)pcmResourceProvider);
        return sequenceFinder.findTransposeFlowGraphs().parallelStream().map(AbstractTransposeFlowGraph.class::cast).collect(Collectors.toList());
    }
}

