/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core;

import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.pcm.core.PCMCharacteristicValue;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.dataflowanalysis.pcm.extension.model.confidentiality.characteristics.EnumCharacteristic;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.AbstractAssignee;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.AssemblyAssignee;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.Assignments;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.NodeCharacteristicsFactory;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.NodeCharacteristicsPackage;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.ResourceAssignee;
import org.dataflowanalysis.pcm.extension.nodecharacteristics.nodecharacteristics.UsageAssignee;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;

public class PCMVertexCharacteristicsCalculator {
    private final Logger logger = Logger.getLogger(PCMVertexCharacteristicsCalculator.class);
    private final ResourceProvider resourceLoader;

    public PCMVertexCharacteristicsCalculator(ResourceProvider resourceProvider) {
        this.resourceLoader = resourceProvider;
    }

    public List<CharacteristicValue> getVertexCharacteristics(Entity node, Deque<AssemblyContext> context) {
        return this.getVertexCharacteristics(node, context, new IdentityHashMap<AbstractAssignee, AbstractAssignee>());
    }

    public List<CharacteristicValue> getVertexCharacteristics(Entity node, Deque<AssemblyContext> context, Map<AbstractAssignee, AbstractAssignee> replacements) {
        List<AbstractAssignee> assignees;
        Assignments assignments = this.resolveAssignments();
        replacements.keySet().forEach(assignee -> {
            boolean bl = assignments.getAssignee().remove(assignee);
        });
        replacements.values().forEach(assignee -> {
            boolean bl = assignments.getAssignee().add(assignee);
        });
        if (node instanceof AbstractUserAction) {
            assignees = this.getUsageNodeAssignments(node, assignments);
        } else if (node instanceof AbstractAction) {
            assignees = this.getSEFFNodeAssignments(assignments, context);
        } else {
            this.logger.error((Object)String.format("Requested node characteristics of unknown entity %s", node));
            throw new IllegalArgumentException();
        }
        List enumCharacteristics = assignees.stream().flatMap(it -> it.getCharacteristics().stream()).toList();
        return enumCharacteristics.stream().flatMap(it -> it.getValues().stream().map(val -> new PCMCharacteristicValue((EnumCharacteristicType)it.getType(), (Literal)val))).collect(Collectors.toList());
    }

    private List<AbstractAssignee> getUsageNodeAssignments(Entity node, Assignments assignments) {
        UsageScenario usageScenario = PCMQueryUtils.findParentOfType((EObject)node, UsageScenario.class, false).orElseThrow(IllegalStateException::new);
        return assignments.getAssignee().stream().filter(UsageAssignee.class::isInstance).map(UsageAssignee.class::cast).filter(it -> it.getUsagescenario().equals(usageScenario)).collect(Collectors.toList());
    }

    private List<AbstractAssignee> getSEFFNodeAssignments(Assignments assignments, Deque<AssemblyContext> context) {
        ArrayList<AbstractAssignee> resolvedAssignees = new ArrayList<AbstractAssignee>();
        List<Allocation> allocations = this.resourceLoader.lookupToplevelElement(AllocationPackage.eINSTANCE.getAllocation()).stream().filter(Allocation.class::isInstance).map(Allocation.class::cast).toList();
        Optional<Allocation> allocation = allocations.stream().filter(it -> it.getAllocationContexts_Allocation().stream().map(AllocationContext::getAssemblyContext_AllocationContext).anyMatch(((AssemblyContext)context.getFirst())::equals)).findFirst();
        if (allocation.isEmpty()) {
            this.logger.error((Object)"Could not find fitting allocation for assembly context of SEFF Node");
            throw new IllegalStateException();
        }
        EList allocationContexts = allocation.get().getAllocationContexts_Allocation();
        allocationContexts.stream().filter(it -> context.contains(it.getAssemblyContext_AllocationContext())).forEach(it -> {
            resolvedAssignees.addAll(this.getAllocationAssignees(assignments, it.getAssemblyContext_AllocationContext()));
            resolvedAssignees.addAll(this.getResourceAssignees(assignments, it.getResourceContainer_AllocationContext()));
            if (it.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) {
                resolvedAssignees.addAll(this.getCompositeComponentAssignees(assignments, context, (CompositeComponent)it.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext()));
            }
        });
        return resolvedAssignees;
    }

    private List<AbstractAssignee> getAllocationAssignees(Assignments assignments, AssemblyContext assemblyContext) {
        return assignments.getAssignee().stream().filter(AssemblyAssignee.class::isInstance).map(AssemblyAssignee.class::cast).filter(it -> it.getAssemblycontext().equals(assemblyContext)).collect(Collectors.toList());
    }

    private List<AbstractAssignee> getResourceAssignees(Assignments assignments, ResourceContainer resourceContainer) {
        return assignments.getAssignee().stream().filter(ResourceAssignee.class::isInstance).map(ResourceAssignee.class::cast).filter(it -> it.getResourcecontainer().equals(resourceContainer)).collect(Collectors.toList());
    }

    private List<AbstractAssignee> getCompositeComponentAssignees(Assignments assignments, Deque<AssemblyContext> context, CompositeComponent compositeComponent) {
        ArrayList<AbstractAssignee> evaluatedAssignees = new ArrayList<AbstractAssignee>();
        EList assemblyContexts = compositeComponent.getAssemblyContexts__ComposedStructure();
        for (AssemblyContext assemblyContext : assemblyContexts) {
            if (!context.contains(assemblyContext)) continue;
            evaluatedAssignees.addAll(this.getAllocationAssignees(assignments, assemblyContext));
        }
        return evaluatedAssignees;
    }

    private Assignments resolveAssignments() {
        return this.resourceLoader.lookupToplevelElement(NodeCharacteristicsPackage.eINSTANCE.getAssignments()).stream().filter(Assignments.class::isInstance).map(Assignments.class::cast).findFirst().orElse(NodeCharacteristicsFactory.eINSTANCE.createAssignments());
    }

    public void checkAssignments() {
        Assignments assignments = this.resolveAssignments();
        for (AbstractAssignee assignee : assignments.getAssignee()) {
            if (assignee instanceof UsageAssignee) {
                UsageAssignee usage = (UsageAssignee)assignee;
                if (!this.presentInUsageModel(usage.getUsagescenario())) {
                    throw new IllegalStateException("Referenced Usage Scenario is not loaded!");
                }
                this.checkCharacteristics(usage.getCharacteristics());
                continue;
            }
            if (assignee instanceof ResourceAssignee) {
                ResourceAssignee resource = (ResourceAssignee)assignee;
                if (!this.presentInResource(resource.getResourcecontainer())) {
                    throw new IllegalStateException("Referenced Resource container is not loaded!");
                }
                this.checkCharacteristics(resource.getCharacteristics());
                continue;
            }
            if (assignee instanceof AssemblyAssignee) {
                AssemblyAssignee assembly = (AssemblyAssignee)assignee;
                if (!this.presentInAssembly(assembly.getAssemblycontext()) && !this.presentInComposite(assembly.getAssemblycontext())) {
                    throw new IllegalStateException("Referenced Assembly context is not loaded!");
                }
                this.checkCharacteristics(assembly.getCharacteristics());
                continue;
            }
            throw new IllegalStateException("Assignments contain unknown assignment target");
        }
    }

    private boolean presentInUsageModel(UsageScenario usageScenario) {
        List<UsageModel> usageModel = this.resourceLoader.lookupToplevelElement(UsagemodelPackage.eINSTANCE.getUsageModel()).parallelStream().filter(UsageModel.class::isInstance).map(UsageModel.class::cast).toList();
        return usageModel.stream().anyMatch(it -> it.getUsageScenario_UsageModel().contains((Object)usageScenario));
    }

    private boolean presentInResource(ResourceContainer resourceContainer) {
        List<ResourceEnvironment> resourceEnvironments = this.resourceLoader.lookupToplevelElement(ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment()).parallelStream().filter(ResourceEnvironment.class::isInstance).map(ResourceEnvironment.class::cast).toList();
        return resourceEnvironments.stream().anyMatch(it -> it.getResourceContainer_ResourceEnvironment().contains((Object)resourceContainer));
    }

    private boolean presentInAssembly(AssemblyContext assemblyContext) {
        List<System> systems = this.resourceLoader.lookupToplevelElement(SystemPackage.eINSTANCE.getSystem()).parallelStream().filter(System.class::isInstance).map(System.class::cast).toList();
        return systems.stream().anyMatch(it -> it.getAssemblyContexts__ComposedStructure().contains((Object)assemblyContext));
    }

    private boolean presentInComposite(AssemblyContext assemblyContext) {
        List<Repository> repositories = this.resourceLoader.lookupToplevelElement(RepositoryPackage.eINSTANCE.getRepository()).parallelStream().filter(Repository.class::isInstance).map(Repository.class::cast).toList();
        List<CompositeComponent> compositeComponents = repositories.parallelStream().flatMap(it -> it.getComponents__Repository().stream()).filter(CompositeComponent.class::isInstance).map(CompositeComponent.class::cast).toList();
        return compositeComponents.stream().anyMatch(it -> it.getAssemblyContexts__ComposedStructure().contains((Object)assemblyContext));
    }

    public void checkCharacteristics(List<EnumCharacteristic> characteristics) {
        for (EnumCharacteristic characteristic : characteristics) {
            EList allowedLiterals = ((EnumCharacteristicType)characteristic.getType()).getType().getLiterals();
            EList foundLiterals = characteristic.getValues();
            List<Literal> unknownLiterals = foundLiterals.parallelStream().filter(arg_0 -> PCMVertexCharacteristicsCalculator.lambda$39((List)allowedLiterals, arg_0)).toList();
            if (unknownLiterals.isEmpty()) continue;
            throw new IllegalStateException("Found unknown literal " + unknownLiterals.get(0).getName() + " in assigned characteristics!");
        }
    }

    private static /* synthetic */ boolean lambda$39(List list, Literal it) {
        return !list.contains(it);
    }
}

