/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.finder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.PCMTransposeFlowGraph;
import org.dataflowanalysis.analysis.pcm.core.finder.PCMUserTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.core.finder.SEFFFinderContext;
import org.dataflowanalysis.analysis.pcm.core.seff.CallingSEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.seff.SEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.CallingUserPCMVertex;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.analysis.pcm.utils.SEFFWithContext;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class PCMSEFFTransposeFlowGraphFinder {
    private static final Logger logger = Logger.getLogger(PCMSEFFTransposeFlowGraphFinder.class);
    private final ResourceProvider resourceProvider;
    private final SEFFFinderContext context;
    private final List<Entity> sinks;
    private PCMTransposeFlowGraph currentTransposeFlowGraph;

    public PCMSEFFTransposeFlowGraphFinder(ResourceProvider resourceProvider, SEFFFinderContext context, List<Entity> sinks, PCMTransposeFlowGraph currentTransposeFlowGraph) {
        this.resourceProvider = resourceProvider;
        this.context = context;
        this.sinks = sinks;
        this.currentTransposeFlowGraph = currentTransposeFlowGraph;
    }

    public List<PCMTransposeFlowGraph> findSequencesForSEFFAction(AbstractAction currentAction) {
        if (currentAction instanceof StartAction) {
            return this.findSequencesForSEFFStartAction((StartAction)currentAction);
        }
        if (currentAction instanceof StopAction) {
            return this.findSequencesForSEFFStopAction((StopAction)currentAction);
        }
        if (currentAction instanceof ExternalCallAction) {
            return this.findSequencesForSEFFExternalCallAction((ExternalCallAction)currentAction);
        }
        if (currentAction instanceof SetVariableAction) {
            return this.findSequencesForSEFFSetVariableAction((SetVariableAction)currentAction);
        }
        if (currentAction instanceof BranchAction) {
            return this.findSequencesForSEFFBranchAction((BranchAction)currentAction);
        }
        logger.info((Object)String.format("Action %s has unsupported type of %s and is skipped.", currentAction.getId(), currentAction.getClass().getName()));
        return this.findSequencesForSEFFAction(currentAction.getSuccessor_AbstractAction());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFStartAction(StartAction currentAction) {
        SEFFPCMVertex<StartAction> startElement = this.currentTransposeFlowGraph.getSink() == null ? new SEFFPCMVertex<StartAction>(currentAction, List.of(), this.context.getContext(), this.context.getParameter(), this.resourceProvider) : new SEFFPCMVertex<StartAction>(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.context.getContext(), this.context.getParameter(), this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(startElement);
        if (this.sinks.stream().anyMatch(it -> it.getId().equals(currentAction.getId()))) {
            return List.of(this.currentTransposeFlowGraph);
        }
        return this.findSequencesForSEFFAction(currentAction.getSuccessor_AbstractAction());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFStopAction(StopAction currentAction) {
        SEFFPCMVertex<StopAction> stopElement = new SEFFPCMVertex<StopAction>(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.context.getContext(), this.context.getParameter(), this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(stopElement);
        if (this.sinks.stream().anyMatch(it -> it.getId().equals(currentAction.getId()))) {
            return List.of(this.currentTransposeFlowGraph);
        }
        Optional<AbstractAction> parentAction = PCMQueryUtils.findParentOfType((EObject)currentAction, AbstractAction.class, false);
        if (parentAction.isPresent()) {
            AbstractAction successor = parentAction.get().getSuccessor_AbstractAction();
            return this.findSequencesForSEFFAction(successor);
        }
        AbstractPCMVertex<?> caller = this.context.getLastCaller();
        this.context.updateParameterForCallerReturning(caller);
        return this.returnToCaller(caller);
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFExternalCallAction(ExternalCallAction currentAction) {
        OperationSignature calledSignature;
        CallingSEFFPCMVertex callingEntity = new CallingSEFFPCMVertex(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.context.getContext(), this.context.getParameter(), true, this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(callingEntity);
        if (this.sinks.stream().anyMatch(it -> it.getId().equals(currentAction.getId()))) {
            return List.of(this.currentTransposeFlowGraph);
        }
        OperationRequiredRole calledRole = currentAction.getRole_ExternalService();
        Optional<SEFFWithContext> calledSEFF = PCMQueryUtils.findCalledSEFF((RequiredRole)calledRole, calledSignature = currentAction.getCalledService_ExternalService(), this.context.getContext());
        if (calledSEFF.isEmpty()) {
            logger.error((Object)String.format("Could not find the called SEFF for the action %s", currentAction));
            throw new IllegalStateException();
        }
        Optional<StartAction> SEFFStartAction = PCMQueryUtils.getFirstStartActionInActionList((List<AbstractAction>)calledSEFF.get().seff().getSteps_Behaviour());
        if (SEFFStartAction.isEmpty()) {
            throw new IllegalStateException("Unable to find SEFF start action");
        }
        this.context.addCaller(callingEntity);
        this.context.updateSEFFContext(calledSEFF.get().context());
        this.context.updateParametersForCall((List<Parameter>)calledSignature.getParameters__OperationSignature());
        return this.findSequencesForSEFFAction((AbstractAction)SEFFStartAction.get());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFSetVariableAction(SetVariableAction currentAction) {
        SEFFPCMVertex<SetVariableAction> newEntity = new SEFFPCMVertex<SetVariableAction>(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.context.getContext(), this.context.getParameter(), this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(newEntity);
        if (this.sinks.stream().anyMatch(it -> it.getId().equals(currentAction.getId()))) {
            return List.of(this.currentTransposeFlowGraph);
        }
        return this.findSequencesForSEFFAction(currentAction.getSuccessor_AbstractAction());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFBranchAction(BranchAction currentAction) {
        return currentAction.getBranches_Branch().stream().map(AbstractBranchTransition::getBranchBehaviour_BranchTransition).map(ResourceDemandingBehaviour::getSteps_Behaviour).map(PCMQueryUtils::getFirstStartActionInActionList).flatMap(Optional::stream).map(it -> {
            IdentityHashMap vertexMapping = new IdentityHashMap();
            PCMTransposeFlowGraph clonedTransposeFlowGraph = this.currentTransposeFlowGraph.copy(vertexMapping);
            SEFFFinderContext clonedContext = new SEFFFinderContext(this.context);
            clonedContext.replaceCallers(vertexMapping);
            return new PCMSEFFTransposeFlowGraphFinder(this.resourceProvider, clonedContext, this.sinks, clonedTransposeFlowGraph).findSequencesForSEFFAction((AbstractAction)it);
        }).flatMap(Collection::stream).toList();
    }

    protected List<PCMTransposeFlowGraph> findSequencesForSEFFActionReturning(ExternalCallAction currentAction, AbstractPCMVertex<?> caller) {
        ArrayList<AbstractVertex> previousVertices = new ArrayList<AbstractVertex>();
        previousVertices.add(caller);
        previousVertices.add(this.currentTransposeFlowGraph.getSink());
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(new CallingSEFFPCMVertex(currentAction, previousVertices, this.context.getContext(), this.context.getParameter(), false, this.resourceProvider));
        if (this.sinks.stream().anyMatch(it -> it.getId().equals(currentAction.getId()))) {
            return List.of(this.currentTransposeFlowGraph);
        }
        return this.findSequencesForSEFFAction(currentAction.getSuccessor_AbstractAction());
    }

    public List<PCMTransposeFlowGraph> returnToCaller(AbstractVertex<?> caller) {
        if (caller instanceof CallingUserPCMVertex) {
            return this.returnToUserCaller((CallingUserPCMVertex)caller);
        }
        if (caller instanceof CallingSEFFPCMVertex) {
            return this.returnToSEFFCaller((CallingSEFFPCMVertex)caller);
        }
        throw new IllegalArgumentException(String.format("No dispatch logic for call of type %s available.", caller.getClass().getSimpleName()));
    }

    protected List<PCMTransposeFlowGraph> returnToUserCaller(CallingUserPCMVertex caller) {
        if (!this.context.getCallers().isEmpty()) {
            logger.error((Object)"SEFF Action wanted to return without a matching calling user sequence element");
            throw new IllegalStateException();
        }
        return new PCMUserTransposeFlowGraphFinder(this.resourceProvider, this.currentTransposeFlowGraph, this.sinks).findSequencesForUserActionReturning((EntryLevelSystemCall)caller.getReferencedElement(), caller);
    }

    protected List<PCMTransposeFlowGraph> returnToSEFFCaller(CallingSEFFPCMVertex caller) {
        this.context.updateSEFFContext(caller.getContext());
        return this.findSequencesForSEFFActionReturning((ExternalCallAction)caller.getReferencedElement(), caller);
    }
}

