/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.finder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.TransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.core.PCMTransposeFlowGraph;
import org.dataflowanalysis.analysis.pcm.core.finder.PCMSEFFTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.core.finder.PCMUserTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.core.finder.SEFFFinderContext;
import org.dataflowanalysis.analysis.pcm.resource.PCMResourceProvider;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;

public class PCMTransposeFlowGraphFinder
implements TransposeFlowGraphFinder {
    private final Logger logger = Logger.getLogger(PCMTransposeFlowGraphFinder.class);
    private final ResourceProvider resourceProvider;
    private final Collection<AssemblyContext> contexts;
    private final Collection<Parameter> parameter;

    public PCMTransposeFlowGraphFinder(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.contexts = List.of();
        this.parameter = List.of();
    }

    public PCMTransposeFlowGraphFinder(ResourceProvider resourceProvider, Collection<AssemblyContext> contexts, Collection<Parameter> parameter) {
        this.resourceProvider = resourceProvider;
        this.contexts = contexts;
        this.parameter = parameter;
    }

    /*
     * WARNING - void declaration
     */
    public List<? extends PCMTransposeFlowGraph> findTransposeFlowGraphs() {
        void pcmResourceProvider;
        ResourceProvider resourceProvider = this.resourceProvider;
        if (!(resourceProvider instanceof PCMResourceProvider)) {
            this.logger.error((Object)"Resource provider of the transpose flow graph finder is not a pcm resource provider, please provide a correct one");
            throw new IllegalStateException();
        }
        PCMResourceProvider pCMResourceProvider = (PCMResourceProvider)resourceProvider;
        return this.findTransposeFlowGraphs(List.of(), PCMQueryUtils.findStartActionsForUsageModel(pcmResourceProvider.getUsageModel()));
    }

    public List<? extends PCMTransposeFlowGraph> findTransposeFlowGraphs(List<?> sourceNodes) {
        return this.findTransposeFlowGraphs(sourceNodes, List.of());
    }

    public List<? extends PCMTransposeFlowGraph> findTransposeFlowGraphs(List<?> sinkNodes, List<?> sourceNodes) {
        ArrayList<PCMTransposeFlowGraph> transposeFlowGraphs = new ArrayList<PCMTransposeFlowGraph>();
        List<AbstractUserAction> userActions = sourceNodes.stream().filter(AbstractUserAction.class::isInstance).map(AbstractUserAction.class::cast).toList();
        List<AbstractAction> seffActions = sourceNodes.stream().filter(AbstractAction.class::isInstance).map(AbstractAction.class::cast).toList();
        List<Entity> sinks = sinkNodes.stream().filter(Entity.class::isInstance).map(Entity.class::cast).toList();
        transposeFlowGraphs.addAll(this.findTransposeFlowGraphsForUserActions(userActions, sinks));
        transposeFlowGraphs.addAll(this.findTransposeFlowGraphsForSEFFActions(seffActions, sinks));
        this.logger.info((Object)String.format("Found %d transpose flow %s.", transposeFlowGraphs.size(), transposeFlowGraphs.size() == 1 ? "graph" : "graphs"));
        return transposeFlowGraphs;
    }

    private List<PCMTransposeFlowGraph> findTransposeFlowGraphsForUserActions(List<AbstractUserAction> userActions, List<Entity> sinks) {
        return userActions.stream().map(it -> new PCMUserTransposeFlowGraphFinder(this.resourceProvider, sinks).findSequencesForUserAction((AbstractUserAction)it)).flatMap(Collection::stream).toList();
    }

    private List<PCMTransposeFlowGraph> findTransposeFlowGraphsForSEFFActions(List<AbstractAction> seffActions, List<Entity> sinks) {
        SEFFFinderContext context = new SEFFFinderContext(new ArrayDeque<AssemblyContext>(this.contexts), new ArrayDeque(), new ArrayList<Parameter>(this.parameter));
        return seffActions.stream().map(it -> new PCMSEFFTransposeFlowGraphFinder(this.resourceProvider, context, sinks, new PCMTransposeFlowGraph()).findSequencesForSEFFAction((AbstractAction)it)).flatMap(Collection::stream).toList();
    }
}

