/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.finder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.PCMTransposeFlowGraph;
import org.dataflowanalysis.analysis.pcm.core.finder.PCMSEFFTransposeFlowGraphFinder;
import org.dataflowanalysis.analysis.pcm.core.finder.SEFFFinderContext;
import org.dataflowanalysis.analysis.pcm.core.user.CallingUserPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.UserPCMVertex;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.analysis.pcm.utils.SEFFWithContext;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

public class PCMUserTransposeFlowGraphFinder {
    private static final Logger logger = Logger.getLogger(PCMUserTransposeFlowGraphFinder.class);
    private final ResourceProvider resourceProvider;
    private PCMTransposeFlowGraph currentTransposeFlowGraph;
    private final List<Entity> sinks;

    public PCMUserTransposeFlowGraphFinder(ResourceProvider resourceProvider, List<Entity> sinks) {
        this.resourceProvider = resourceProvider;
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph();
        this.sinks = sinks;
    }

    public PCMUserTransposeFlowGraphFinder(ResourceProvider resourceProvider, PCMTransposeFlowGraph currentTransposeFlowGraph, List<Entity> sinks) {
        this.resourceProvider = resourceProvider;
        this.currentTransposeFlowGraph = currentTransposeFlowGraph;
        this.sinks = sinks;
    }

    public List<PCMTransposeFlowGraph> findSequencesForUserAction(AbstractUserAction initialAction) {
        if (this.sinks.contains(initialAction)) {
            return List.of(this.currentTransposeFlowGraph);
        }
        if (initialAction instanceof Start) {
            return this.findSequencesForUserStartAction((Start)initialAction);
        }
        if (initialAction instanceof Stop) {
            return this.findSequencesForUserStopAction((Stop)initialAction);
        }
        if (initialAction instanceof Branch) {
            return this.findSequencesForUserBranchAction((Branch)initialAction);
        }
        if (initialAction instanceof EntryLevelSystemCall) {
            return this.findSequencesForEntryLevelSystemCall((EntryLevelSystemCall)initialAction);
        }
        logger.info((Object)String.format("Action %s has unsupported type of %s and is skipped.", initialAction.getId(), initialAction.getClass().getName()));
        return this.findSequencesForUserAction(initialAction.getSuccessor());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForUserStartAction(Start currentAction) {
        UserPCMVertex<Start> startElement = this.currentTransposeFlowGraph.getSink() == null ? new UserPCMVertex<Start>(currentAction, this.resourceProvider) : new UserPCMVertex<Start>(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(startElement);
        return this.findSequencesForUserAction(currentAction.getSuccessor());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForUserStopAction(Stop currentAction) {
        UserPCMVertex<Stop> stopElement = new UserPCMVertex<Stop>(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), this.resourceProvider);
        Optional<AbstractUserAction> parentAction = PCMQueryUtils.findParentOfType((EObject)currentAction, AbstractUserAction.class, false);
        if (parentAction.isEmpty()) {
            return List.of(new PCMTransposeFlowGraph(stopElement));
        }
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(stopElement);
        return this.findSequencesForUserAction(parentAction.get().getSuccessor());
    }

    protected List<PCMTransposeFlowGraph> findSequencesForUserBranchAction(Branch currentAction) {
        return currentAction.getBranchTransitions_Branch().stream().map(BranchTransition::getBranchedBehaviour_BranchTransition).map(PCMQueryUtils::getStartActionOfScenarioBehavior).flatMap(Optional::stream).map(it -> {
            IdentityHashMap vertexMapping = new IdentityHashMap();
            PCMTransposeFlowGraph clonedTransposeFlowGraph = this.currentTransposeFlowGraph.copy(vertexMapping);
            return new PCMUserTransposeFlowGraphFinder(this.resourceProvider, clonedTransposeFlowGraph, this.sinks).findSequencesForUserAction((AbstractUserAction)it);
        }).flatMap(Collection::stream).toList();
    }

    protected List<PCMTransposeFlowGraph> findSequencesForEntryLevelSystemCall(EntryLevelSystemCall currentAction) {
        OperationSignature calledSignature;
        CallingUserPCMVertex callingEntity = new CallingUserPCMVertex(currentAction, List.of(this.currentTransposeFlowGraph.getSink()), true, this.resourceProvider);
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(callingEntity);
        OperationProvidedRole calledRole = currentAction.getProvidedRole_EntryLevelSystemCall();
        Optional<SEFFWithContext> calledSEFF = PCMQueryUtils.findCalledSEFF((ProvidedRole)calledRole, (Signature)(calledSignature = currentAction.getOperationSignature__EntryLevelSystemCall()), new ArrayDeque<AssemblyContext>());
        if (calledSEFF.isEmpty()) {
            logger.error((Object)String.format("Could not find the called SEFF for the action %s", currentAction));
            throw new IllegalStateException();
        }
        Optional<StartAction> SEFFStartAction = PCMQueryUtils.getFirstStartActionInActionList((List<AbstractAction>)calledSEFF.get().seff().getSteps_Behaviour());
        if (SEFFStartAction.isEmpty()) {
            throw new IllegalStateException("Unable to find SEFF start action");
        }
        ArrayDeque callers = new ArrayDeque();
        callers.add(callingEntity);
        SEFFFinderContext finderContext = new SEFFFinderContext(calledSEFF.get().context(), callers, (List<Parameter>)calledSignature.getParameters__OperationSignature());
        return new PCMSEFFTransposeFlowGraphFinder(this.resourceProvider, finderContext, this.sinks, this.currentTransposeFlowGraph).findSequencesForSEFFAction((AbstractAction)SEFFStartAction.get());
    }

    public List<PCMTransposeFlowGraph> findSequencesForUserActionReturning(EntryLevelSystemCall currentAction, AbstractPCMVertex<?> caller) {
        ArrayList<AbstractVertex> previousVertices = new ArrayList<AbstractVertex>();
        previousVertices.add(caller);
        previousVertices.add(this.currentTransposeFlowGraph.getSink());
        this.currentTransposeFlowGraph = new PCMTransposeFlowGraph(new CallingUserPCMVertex(currentAction, previousVertices, false, this.resourceProvider));
        return this.findSequencesForUserAction(currentAction.getSuccessor());
    }
}

