/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.finder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.seff.CallingSEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.CallingUserPCMVertex;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class SEFFFinderContext {
    private Deque<AssemblyContext> context;
    private Deque<AbstractPCMVertex<?>> callers;
    private List<Parameter> parameter;

    public SEFFFinderContext(Deque<AssemblyContext> context, Deque<AbstractPCMVertex<?>> callers, List<Parameter> parameter) {
        this.context = context;
        this.callers = callers;
        this.parameter = parameter;
    }

    public SEFFFinderContext(SEFFFinderContext context) {
        this.context = new ArrayDeque<AssemblyContext>(context.getContext());
        this.callers = new ArrayDeque(context.getCallers());
        this.parameter = new ArrayList<Parameter>(context.getParameter());
    }

    public void updateParameterForCallerReturning(AbstractVertex<?> caller) {
        if (caller instanceof CallingUserPCMVertex) {
            CallingUserPCMVertex callingUserElement = (CallingUserPCMVertex)caller;
            this.parameter = ((EntryLevelSystemCall)callingUserElement.getReferencedElement()).getOperationSignature__EntryLevelSystemCall().getParameters__OperationSignature();
        } else {
            this.parameter = ((CallingSEFFPCMVertex)caller).getParameter();
        }
    }

    public void replaceCallers(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        ArrayDeque newCallers = new ArrayDeque();
        while (!this.callers.isEmpty()) {
            AbstractPCMVertex<?> element = this.callers.pop();
            AbstractPCMVertex<?> mappedElement = vertexMapping.getOrDefault(element, element);
            newCallers.addLast(mappedElement);
        }
        this.callers = newCallers;
    }

    public void updateParametersForCall(List<Parameter> passedVariables) {
        this.parameter = passedVariables;
    }

    public void updateSEFFContext(Deque<AssemblyContext> newContext) {
        this.context = newContext;
    }

    public AbstractPCMVertex<?> getLastCaller() {
        return this.callers.removeLast();
    }

    public void addCaller(AbstractPCMVertex<?> caller) {
        this.callers.add(caller);
    }

    public Deque<AssemblyContext> getContext() {
        return this.context;
    }

    public Deque<AbstractPCMVertex<?>> getCallers() {
        return this.callers;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }
}

