/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.seff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.CallReturnBehavior;
import org.dataflowanalysis.analysis.pcm.core.seff.SEFFPCMVertex;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.ExternalCallAction;

public class CallingSEFFPCMVertex
extends SEFFPCMVertex<ExternalCallAction>
implements CallReturnBehavior {
    private final boolean isCalling;

    public CallingSEFFPCMVertex(ExternalCallAction element, List<? extends AbstractPCMVertex<?>> previousElements, Deque<AssemblyContext> context, List<Parameter> parameter, boolean isCalling, ResourceProvider resourceProvider) {
        super(element, previousElements, context, parameter, resourceProvider);
        this.isCalling = isCalling;
    }

    @Override
    public boolean isCalling() {
        return this.isCalling;
    }

    @Override
    public void evaluateDataFlow() {
        List<DataCharacteristic> incomingDataCharacteristics = this.getIncomingDataCharacteristics();
        List<CharacteristicValue> nodeCharacteristics = this.getVertexCharacteristics();
        List<ConfidentialityVariableCharacterisation> variableCharacterisations = this.getVariableCharacterizations();
        if (this.isCalling()) {
            this.checkCallParameter(((ExternalCallAction)this.getReferencedElement()).getCalledService_ExternalService(), variableCharacterisations);
        }
        List<Object> outgoingDataCharacteristics = this.getDataCharacteristics(nodeCharacteristics, variableCharacterisations, incomingDataCharacteristics);
        if (this.isReturning()) {
            outgoingDataCharacteristics = outgoingDataCharacteristics.stream().filter(it -> !it.getVariableName().equals("RETURN")).collect(Collectors.toList());
        }
        this.setPropagationResult(incomingDataCharacteristics, outgoingDataCharacteristics, nodeCharacteristics);
    }

    private List<ConfidentialityVariableCharacterisation> getVariableCharacterizations() {
        Stream relevantVariableUsages = this.isCalling ? ((ExternalCallAction)super.getReferencedElement()).getInputVariableUsages__CallAction().stream() : ((ExternalCallAction)super.getReferencedElement()).getReturnVariableUsage__CallReturnAction().stream();
        return relevantVariableUsages.flatMap(it -> it.getVariableCharacterisation_VariableUsage().stream()).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        String calling = this.isCalling ? "calling" : "returning";
        return String.format("%s / %s (%s, %s))", this.getClass().getSimpleName(), calling, ((ExternalCallAction)this.getReferencedElement()).getEntityName(), ((ExternalCallAction)this.getReferencedElement()).getId());
    }

    @Override
    public AbstractPCMVertex<?> copy(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        if (vertexMapping.get(this) != null) {
            return vertexMapping.get(this);
        }
        CallingSEFFPCMVertex copy = new CallingSEFFPCMVertex((ExternalCallAction)this.referencedElement, List.of(), new ArrayDeque<AssemblyContext>(this.context), new ArrayList<Parameter>(this.getParameter()), this.isCalling, this.resourceProvider);
        return super.updateCopy(copy, vertexMapping);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEquivalentInContext(Object otherVertexObject) {
        void otherVertex;
        if (!(otherVertexObject instanceof CallingSEFFPCMVertex)) {
            return false;
        }
        CallingSEFFPCMVertex callingSEFFPCMVertex = (CallingSEFFPCMVertex)otherVertexObject;
        return super.isEquivalentInContext(otherVertex) && this.isCalling() == otherVertex.isCalling();
    }

    @Override
    public int hashCode() {
        return Objects.hash(((ExternalCallAction)this.getReferencedElement()).getId(), this.isCalling);
    }
}

