/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.seff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.utils.PCMQueryUtils;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;

public class SEFFPCMVertex<T extends AbstractAction>
extends AbstractPCMVertex<T> {
    private final Logger logger = Logger.getLogger(SEFFPCMVertex.class);
    private final List<Parameter> parameter;

    public SEFFPCMVertex(T element, List<? extends AbstractPCMVertex<?>> previousElements, Deque<AssemblyContext> context, List<Parameter> parameter, ResourceProvider resourceProvider) {
        super(element, previousElements, context, resourceProvider);
        this.parameter = parameter;
    }

    public void evaluateDataFlow() {
        List<DataCharacteristic> incomingDataCharacteristics = this.getIncomingDataCharacteristics();
        List<CharacteristicValue> nodeCharacteristics = this.getVertexCharacteristics();
        if (this.getReferencedElement() instanceof StartAction && !this.isBranching()) {
            List<String> variableNames = this.getParameter().stream().map(Parameter::getParameterName).toList();
            incomingDataCharacteristics = incomingDataCharacteristics.stream().filter(it -> variableNames.contains(it.variableName())).toList();
            this.setPropagationResult(incomingDataCharacteristics, incomingDataCharacteristics, nodeCharacteristics);
            return;
        }
        if (this.getReferencedElement() instanceof StartAction) {
            this.setPropagationResult(incomingDataCharacteristics, incomingDataCharacteristics, nodeCharacteristics);
            return;
        }
        if (this.getReferencedElement() instanceof StopAction && !this.isBranching()) {
            List<DataCharacteristic> outgoingDataCharacteristics = incomingDataCharacteristics.parallelStream().filter(it -> it.getVariableName().equals("RETURN")).collect(Collectors.toList());
            this.setPropagationResult(incomingDataCharacteristics, outgoingDataCharacteristics, nodeCharacteristics);
            return;
        }
        if (this.getReferencedElement() instanceof StopAction) {
            this.setPropagationResult(incomingDataCharacteristics, incomingDataCharacteristics, nodeCharacteristics);
            return;
        }
        if (!(this.getReferencedElement() instanceof SetVariableAction)) {
            this.logger.error((Object)("Found unexpected sequence element of unknown PCM type " + ((AbstractAction)this.getReferencedElement()).getClass().getName()));
            throw new IllegalStateException("Unexpected action sequence element with unknown PCM type");
        }
        List<ConfidentialityVariableCharacterisation> variableCharacterisations = ((SetVariableAction)this.getReferencedElement()).getLocalVariableUsages_SetVariableAction().stream().flatMap(it -> it.getVariableCharacterisation_VariableUsage().stream()).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).toList();
        List<DataCharacteristic> outgoingDataCharacteristics = this.getDataCharacteristics(nodeCharacteristics, variableCharacterisations, incomingDataCharacteristics);
        this.setPropagationResult(incomingDataCharacteristics, outgoingDataCharacteristics, nodeCharacteristics);
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public boolean isBranching() {
        Optional<BranchAction> branchAction = PCMQueryUtils.findParentOfType(this.getReferencedElement(), BranchAction.class, false);
        return branchAction.isPresent();
    }

    public String toString() {
        Optional<ResourceDemandingSEFF> seff;
        Object elementName = ((AbstractAction)this.getReferencedElement()).getEntityName();
        if (this.getReferencedElement() instanceof StartAction) {
            seff = PCMQueryUtils.findParentOfType(this.getReferencedElement(), ResourceDemandingSEFF.class, false);
            if (seff.isPresent()) {
                elementName = "Beginning " + seff.get().getDescribedService__SEFF().getEntityName();
            }
            if (this.isBranching() && seff.isPresent()) {
                BranchAction branchAction = PCMQueryUtils.findParentOfType(this.getReferencedElement(), BranchAction.class, false).orElseThrow(() -> new IllegalStateException("Cannot find branch action"));
                AbstractBranchTransition branchTransition = PCMQueryUtils.findParentOfType(this.getReferencedElement(), AbstractBranchTransition.class, false).orElseThrow(() -> new IllegalStateException("Cannot find branch transition"));
                elementName = "Branching " + seff.get().getDescribedService__SEFF().getEntityName() + "." + branchAction.getEntityName() + "." + branchTransition.getEntityName();
            }
        }
        if (this.getReferencedElement() instanceof StopAction && (seff = PCMQueryUtils.findParentOfType(this.getReferencedElement(), ResourceDemandingSEFF.class, false)).isPresent()) {
            elementName = "Ending " + seff.get().getDescribedService__SEFF().getEntityName();
        }
        return String.format("%s (%s, %s))", ((Object)((Object)this)).getClass().getSimpleName(), elementName, ((AbstractAction)this.getReferencedElement()).getId());
    }

    @Override
    public AbstractPCMVertex<?> copy(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        if (vertexMapping.get((Object)this) != null) {
            return vertexMapping.get((Object)this);
        }
        SEFFPCMVertex<AbstractAction> copy = new SEFFPCMVertex<AbstractAction>((AbstractAction)this.referencedElement, List.of(), new ArrayDeque<AssemblyContext>(this.context), new ArrayList<Parameter>(this.getParameter()), this.resourceProvider);
        return super.updateCopy(copy, vertexMapping);
    }
}

