/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.user;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.CallReturnBehavior;
import org.dataflowanalysis.analysis.pcm.core.user.UserPCMVertex;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.dataflowanalysis.pcm.extension.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class CallingUserPCMVertex
extends UserPCMVertex<EntryLevelSystemCall>
implements CallReturnBehavior {
    private final boolean isCalling;

    public CallingUserPCMVertex(EntryLevelSystemCall element, List<? extends AbstractPCMVertex<?>> previousElements, boolean isCalling, ResourceProvider resourceProvider) {
        super(element, previousElements, resourceProvider);
        this.isCalling = isCalling;
    }

    @Override
    public boolean isCalling() {
        return this.isCalling;
    }

    @Override
    public void evaluateDataFlow() {
        List<DataCharacteristic> incomingDataCharacteristics = this.getIncomingDataCharacteristics();
        List<CharacteristicValue> nodeCharacteristics = this.getVertexCharacteristics();
        List<ConfidentialityVariableCharacterisation> variableCharacterisations = this.getVariableCharacterizations();
        if (this.isCalling()) {
            this.checkCallParameter(((EntryLevelSystemCall)this.getReferencedElement()).getOperationSignature__EntryLevelSystemCall(), variableCharacterisations);
        }
        List<Object> outgoingDataCharacteristics = this.getDataCharacteristics(nodeCharacteristics, variableCharacterisations, incomingDataCharacteristics);
        if (this.isReturning()) {
            outgoingDataCharacteristics = outgoingDataCharacteristics.stream().filter(it -> !it.getVariableName().equals("RETURN")).collect(Collectors.toList());
        }
        this.setPropagationResult(incomingDataCharacteristics, outgoingDataCharacteristics, nodeCharacteristics);
    }

    private List<ConfidentialityVariableCharacterisation> getVariableCharacterizations() {
        Stream relevantVariableUsages = this.isCalling ? ((EntryLevelSystemCall)super.getReferencedElement()).getInputParameterUsages_EntryLevelSystemCall().stream() : ((EntryLevelSystemCall)super.getReferencedElement()).getOutputParameterUsages_EntryLevelSystemCall().stream();
        return relevantVariableUsages.flatMap(it -> it.getVariableCharacterisation_VariableUsage().stream()).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        String calling = this.isCalling ? "calling" : "returning";
        return String.format("%s / %s (%s, %s))", this.getClass().getSimpleName(), calling, ((EntryLevelSystemCall)this.getReferencedElement()).getEntityName(), ((EntryLevelSystemCall)this.getReferencedElement()).getId());
    }

    @Override
    public AbstractPCMVertex<?> copy(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        if (vertexMapping.get(this) != null) {
            return vertexMapping.get(this);
        }
        CallingUserPCMVertex copy = new CallingUserPCMVertex((EntryLevelSystemCall)this.referencedElement, List.of(), this.isCalling, this.resourceProvider);
        return super.updateCopy(copy, vertexMapping);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEquivalentInContext(Object otherVertexObject) {
        void otherVertex;
        if (!(otherVertexObject instanceof CallingUserPCMVertex)) {
            return false;
        }
        CallingUserPCMVertex callingUserPCMVertex = (CallingUserPCMVertex)otherVertexObject;
        return super.isEquivalentInContext(otherVertex) && this.isCalling() == otherVertex.isCalling();
    }

    @Override
    public int hashCode() {
        return Objects.hash(((EntryLevelSystemCall)this.getReferencedElement()).getId(), this.isCalling);
    }
}

