/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.core.user;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

public class UserPCMVertex<T extends AbstractUserAction>
extends AbstractPCMVertex<T> {
    private final Logger logger = Logger.getLogger(UserPCMVertex.class);

    public UserPCMVertex(T element, ResourceProvider resourceProvider) {
        super(element, new ArrayDeque<AssemblyContext>(), resourceProvider);
    }

    public UserPCMVertex(T element, List<? extends AbstractPCMVertex<?>> previousElements, ResourceProvider resourceProvider) {
        super(element, previousElements, new ArrayDeque<AssemblyContext>(), resourceProvider);
    }

    public void evaluateDataFlow() {
        List<DataCharacteristic> incomingDataCharacteristics = this.getIncomingDataCharacteristics();
        List<CharacteristicValue> nodeCharacteristics = this.getVertexCharacteristics();
        if (this.getReferencedElement() instanceof Start || this.getReferencedElement() instanceof Stop) {
            this.setPropagationResult(incomingDataCharacteristics, incomingDataCharacteristics, nodeCharacteristics);
            return;
        }
        this.logger.error((Object)("Found unexpected sequence element of unknown PCM type " + ((AbstractUserAction)this.getReferencedElement()).getClass().getName()));
        throw new IllegalStateException("Unexpected action sequence element with unknown PCM type");
    }

    public String toString() {
        if (this.getReferencedElement() instanceof Start) {
            return String.format("%s (Starting %s, %s)", ((Object)((Object)this)).getClass().getSimpleName(), this.getEntityNameOfScenarioBehaviour(), ((AbstractUserAction)this.getReferencedElement()).getId());
        }
        if (this.getReferencedElement() instanceof Stop) {
            return String.format("%s (Stopping %s, %s)", ((Object)((Object)this)).getClass().getSimpleName(), this.getEntityNameOfScenarioBehaviour(), ((AbstractUserAction)this.getReferencedElement()).getId());
        }
        return String.format("%s (%s, %s))", ((Object)((Object)this)).getClass().getSimpleName(), ((AbstractUserAction)this.getReferencedElement()).getEntityName(), ((AbstractUserAction)this.getReferencedElement()).getId());
    }

    public String getEntityNameOfScenarioBehaviour() {
        if (((AbstractUserAction)this.getReferencedElement()).getScenarioBehaviour_AbstractUserAction().getUsageScenario_SenarioBehaviour() != null) {
            return "usage: %s".formatted(((AbstractUserAction)this.getReferencedElement()).getScenarioBehaviour_AbstractUserAction().getUsageScenario_SenarioBehaviour().getEntityName());
        }
        return "branch: %s".formatted(((AbstractUserAction)this.getReferencedElement()).getScenarioBehaviour_AbstractUserAction().getBranchTransition_ScenarioBehaviour().getBranch_BranchTransition().getEntityName());
    }

    @Override
    public AbstractPCMVertex<?> copy(Map<AbstractPCMVertex<?>, AbstractPCMVertex<?>> vertexMapping) {
        if (vertexMapping.get((Object)this) != null) {
            return vertexMapping.get((Object)this);
        }
        UserPCMVertex<AbstractUserAction> copy = new UserPCMVertex<AbstractUserAction>((AbstractUserAction)this.referencedElement, List.of(), this.resourceProvider);
        return super.updateCopy(copy, vertexMapping);
    }
}

