/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.dsl;

import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.dsl.selectors.VertexType;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.CallReturnBehavior;
import org.dataflowanalysis.analysis.pcm.core.seff.SEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.UserPCMVertex;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public enum PCMVertexType implements VertexType
{
    USER,
    SEFF,
    CALLING,
    RETURNING;


    /*
     * WARNING - void declaration
     */
    public boolean matches(AbstractVertex<?> vertex) {
        if (!(vertex instanceof AbstractPCMVertex)) {
            return false;
        }
        AbstractPCMVertex abstractPCMVertex = (AbstractPCMVertex)vertex;
        switch (this) {
            case USER: {
                void pcmVertex;
                return pcmVertex instanceof UserPCMVertex;
            }
            case SEFF: {
                void pcmVertex;
                return pcmVertex instanceof SEFFPCMVertex;
            }
            case CALLING: {
                void pcmVertex;
                return pcmVertex instanceof CallReturnBehavior && ((CallReturnBehavior)pcmVertex).isCalling();
            }
            case RETURNING: {
                void pcmVertex;
                return pcmVertex instanceof CallReturnBehavior && ((CallReturnBehavior)pcmVertex).isReturning();
            }
        }
        return false;
    }

    public static ParseResult<VertexType> fromString(StringView string) {
        if (string.startsWith("USER")) {
            string.advance("USER".length());
            return ParseResult.ok((Object)((Object)USER));
        }
        if (string.startsWith("SEFF")) {
            string.advance("SEFF".length());
            return ParseResult.ok((Object)((Object)SEFF));
        }
        if (string.startsWith("CALLING")) {
            string.advance("CALLING".length());
            return ParseResult.ok((Object)((Object)CALLING));
        }
        if (string.startsWith("RETURNING")) {
            string.advance("RETURNING".length());
            return ParseResult.ok((Object)((Object)RETURNING));
        }
        return ParseResult.error((String)"Invalid pcm vertex type!");
    }
}

