/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.interactive;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.dsl.AnalysisConstraint;
import org.dataflowanalysis.analysis.dsl.result.DSLResult;
import org.dataflowanalysis.analysis.pcm.PCMDataFlowConfidentialityAnalysis;
import org.dataflowanalysis.analysis.pcm.PCMDataFlowConfidentialityAnalysisBuilder;
import org.dataflowanalysis.analysis.pcm.core.PCMFlowGraphCollection;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class PCMAnalysisCLI {
    private static final Logger logger = Logger.getLogger(PCMAnalysisCLI.class);
    private static final String INPUT_INDICATOR = "> ";

    public static void main(String[] args) {
        List<AnalysisConstraint> constraints;
        PCMDataFlowConfidentialityAnalysis analysis;
        if (args.length != 0 && args.length != 4) {
            logger.error((Object)"Please provide either no arguments, or a path to a .usagemodel, .allocation and .nodecharacteristics file and a constraint!");
            System.exit(-1);
        }
        if (args.length == 0) {
            Scanner scanner = new Scanner(System.in);
            analysis = PCMAnalysisCLI.createAnalysisInteractive(scanner);
            constraints = PCMAnalysisCLI.createConstraintInteractive(scanner);
            scanner.close();
        } else {
            if (!args[0].endsWith(".usagemodel")) {
                logger.error((Object)"The first argument should be a path to a .usagemodel file");
                System.exit(-1);
            }
            if (!args[1].endsWith(".allocation")) {
                logger.error((Object)"The second argument should be a path to a .allocation file");
                System.exit(-1);
            }
            if (!args[2].endsWith(".nodecharacteristics")) {
                logger.error((Object)"The second argument should be a path to a .nodecharacteristics file");
                System.exit(-1);
            }
            analysis = PCMAnalysisCLI.createAnalysis(args[0], args[1], args[2]);
            constraints = args[3].endsWith(".dfadsl") ? PCMAnalysisCLI.createConstraintsFromFile(args[3]) : List.of(PCMAnalysisCLI.createConstraint(args[3]));
        }
        analysis.initializeAnalysis();
        PCMFlowGraphCollection flowGraphs = analysis.findFlowGraphs();
        flowGraphs.evaluate();
        int i = 0;
        while (i < constraints.size()) {
            AnalysisConstraint constraint = constraints.get(i);
            List violations = constraint.findViolations((FlowGraphCollection)flowGraphs);
            for (DSLResult violation : violations) {
                logger.info((Object)("Violation for constraint " + i + ":"));
                logger.info((Object)violation.toString());
                logger.info((Object)"-------------------------");
            }
            ++i;
        }
        System.exit(0);
    }

    private static PCMDataFlowConfidentialityAnalysis createAnalysisInteractive(Scanner scanner) {
        System.out.println("Please enter a path to a .usagemodel file: ");
        System.out.print(INPUT_INDICATOR);
        String usageModelPath = scanner.nextLine();
        System.out.println("Please enter a path to a .allocation file: ");
        System.out.print(INPUT_INDICATOR);
        String allocationModelPath = scanner.nextLine();
        System.out.println("Please enter a path to a .nodecharacteristics file: ");
        System.out.print(INPUT_INDICATOR);
        String nodecharacteristicsModelPath = scanner.nextLine();
        return PCMAnalysisCLI.createAnalysis(usageModelPath, allocationModelPath, nodecharacteristicsModelPath);
    }

    private static PCMDataFlowConfidentialityAnalysis createAnalysis(String usageModelPath, String allocationModelPath, String nodecharacteristicsModelPath) {
        return new PCMDataFlowConfidentialityAnalysisBuilder().standalone().useUsageModel(usageModelPath).useAllocationModel(allocationModelPath).useNodeCharacteristicsModel(nodecharacteristicsModelPath).build();
    }

    private static List<AnalysisConstraint> createConstraintInteractive(Scanner scanner) {
        ArrayList<AnalysisConstraint> constraints = new ArrayList<AnalysisConstraint>();
        System.out.println("Please enter constraints: ");
        System.out.print(INPUT_INDICATOR);
        String constraintString = scanner.nextLine();
        while (!constraintString.isEmpty()) {
            constraints.add(PCMAnalysisCLI.createConstraint(constraintString));
            System.out.println("Please enter constraints (end with empty line): ");
            System.out.print(INPUT_INDICATOR);
            constraintString = scanner.nextLine();
        }
        return constraints;
    }

    private static List<AnalysisConstraint> createConstraintsFromFile(String fileName) {
        ArrayList<AnalysisConstraint> constraints = new ArrayList<AnalysisConstraint>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
                List<String> lines = bufferedReader.lines().toList();
                int i = 0;
                while (i < lines.size()) {
                    ParseResult parseResult = AnalysisConstraint.fromString((StringView)new StringView(lines.get(i)));
                    if (parseResult.failed()) {
                        logger.error((Object)("Invalid constraint in line" + i + ":"));
                        logger.error((Object)parseResult.getError());
                        System.exit(-1);
                    }
                    constraints.add((AnalysisConstraint)parseResult.getResult());
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read file!", (Throwable)e);
            System.exit(-1);
        }
        return constraints;
    }

    private static AnalysisConstraint createConstraint(String constraintString) {
        ParseResult parseResult = AnalysisConstraint.fromString((StringView)new StringView(constraintString));
        if (parseResult.failed()) {
            logger.error((Object)"Invalid constraint:");
            logger.error((Object)parseResult.getError());
            System.exit(-1);
        }
        return (AnalysisConstraint)parseResult.getResult();
    }
}

