/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.pcm.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.pcm.core.AbstractPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.PCMTransposeFlowGraph;
import org.dataflowanalysis.analysis.pcm.core.seff.CallingSEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.seff.SEFFPCMVertex;
import org.dataflowanalysis.analysis.pcm.core.user.CallingUserPCMVertex;
import org.dataflowanalysis.analysis.pcm.resource.PCMResourceProvider;
import org.dataflowanalysis.analysis.pcm.utils.SEFFWithContext;
import org.dataflowanalysis.analysis.resource.ResourceProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemPackage;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class PCMQueryUtils {
    private static final Logger logger = Logger.getLogger(PCMQueryUtils.class);

    private PCMQueryUtils() {
        throw new IllegalStateException("Utility classes should not be instantiated");
    }

    public static Optional<Start> getStartActionOfScenarioBehavior(ScenarioBehaviour scenarioBehavior) {
        logger.info((Object)("Finding start action of " + scenarioBehavior.getEntityName()));
        List<Start> candidates = scenarioBehavior.getActions_ScenarioBehaviour().stream().filter(Start.class::isInstance).map(Start.class::cast).toList();
        if (candidates.size() > 1) {
            logger.warn((Object)String.format("UsageScenario %s contains more than one start action.", scenarioBehavior.getEntityName()));
        }
        return candidates.stream().findFirst();
    }

    public static Optional<StartAction> getFirstStartActionInActionList(List<AbstractAction> actionList) {
        return actionList.stream().filter(StartAction.class::isInstance).map(StartAction.class::cast).findFirst();
    }

    public static Optional<StopAction> getFirstStopActionInActionList(List<AbstractAction> actionList) {
        return actionList.stream().filter(StopAction.class::isInstance).map(StopAction.class::cast).findFirst();
    }

    public static List<Start> findStartActionsForUsageModel(UsageModel usageModel) {
        return usageModel.getUsageScenario_UsageModel().stream().map(UsageScenario::getScenarioBehaviour_UsageScenario).map(PCMQueryUtils::getStartActionOfScenarioBehavior).flatMap(Optional::stream).toList();
    }

    public static <T> Optional<T> findParentOfType(EObject object, Class<T> clazz, boolean includeSelf) {
        EObject currentObject = includeSelf ? object : object.eContainer();
        while (currentObject != null && !clazz.isInstance(currentObject)) {
            currentObject = currentObject.eContainer();
        }
        return Optional.ofNullable(currentObject);
    }

    public static Optional<SEFFWithContext> findCalledSEFF(ProvidedRole providedRole, Signature calledSignature, Deque<AssemblyContext> context) {
        ArrayDeque<AssemblyContext> newContexts = new ArrayDeque<AssemblyContext>(context);
        ProvidedRole role = providedRole;
        InterfaceProvidingEntity providingComponent = role.getProvidingEntity_ProvidedRole();
        while (providingComponent instanceof ComposedStructure) {
            Optional<ProvidedDelegationConnector> connector = PCMQueryUtils.findProvidedDelegationConnector((ComposedStructure)providingComponent, role);
            if (connector.isEmpty()) {
                throw new IllegalStateException("Unable to find provided delegation connector.");
            }
            AssemblyContext assemblyContext = connector.get().getAssemblyContext_ProvidedDelegationConnector();
            newContexts.add(assemblyContext);
            role = connector.get().getInnerProvidedRole_ProvidedDelegationConnector();
            providingComponent = role.getProvidingEntity_ProvidedRole();
        }
        if (providingComponent instanceof BasicComponent) {
            BasicComponent component = (BasicComponent)providingComponent;
            Optional<ResourceDemandingSEFF> SEFF = component.getServiceEffectSpecifications__BasicComponent().stream().filter(ResourceDemandingSEFF.class::isInstance).map(ResourceDemandingSEFF.class::cast).filter(it -> it.getDescribedService__SEFF().equals(calledSignature)).findFirst();
            if (SEFF.isEmpty()) {
                throw new IllegalStateException("Unable to find called seff.");
            }
            return Optional.of(new SEFFWithContext(SEFF.get(), newContexts));
        }
        throw new IllegalStateException("Unable to find called seff.");
    }

    public static Optional<SEFFWithContext> findCalledSEFF(RequiredRole requiredRole, OperationSignature calledSignature, Deque<AssemblyContext> context) {
        ComposedStructure composedStructure = context.getLast().getParentStructure__AssemblyContext();
        ArrayDeque<AssemblyContext> newContexts = new ArrayDeque<AssemblyContext>(context);
        Optional<AssemblyConnector> assemblyConnector = composedStructure.getConnectors__ComposedStructure().stream().filter(AssemblyConnector.class::isInstance).map(AssemblyConnector.class::cast).filter(it -> it.getRequiredRole_AssemblyConnector().equals(requiredRole)).filter(it -> it.getRequiringAssemblyContext_AssemblyConnector().equals(newContexts.getLast())).findFirst();
        if (assemblyConnector.isPresent()) {
            newContexts.remove(newContexts.getLast());
            AssemblyContext newAssemblyContext = assemblyConnector.get().getProvidingAssemblyContext_AssemblyConnector();
            OperationProvidedRole providedRole = assemblyConnector.get().getProvidedRole_AssemblyConnector();
            newContexts.add(newAssemblyContext);
            return PCMQueryUtils.findCalledSEFF((ProvidedRole)providedRole, (Signature)calledSignature, newContexts);
        }
        Optional<RequiredRole> outerRequiredRole = composedStructure.getConnectors__ComposedStructure().stream().filter(RequiredDelegationConnector.class::isInstance).map(RequiredDelegationConnector.class::cast).filter(it -> it.getInnerRequiredRole_RequiredDelegationConnector().equals(requiredRole)).map(RequiredDelegationConnector::getOuterRequiredRole_RequiredDelegationConnector).map(RequiredRole.class::cast).findFirst();
        if (outerRequiredRole.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve outer required role.");
        }
        newContexts.remove(newContexts.getLast());
        return PCMQueryUtils.findCalledSEFF(outerRequiredRole.get(), calledSignature, newContexts);
    }

    private static Optional<ProvidedDelegationConnector> findProvidedDelegationConnector(ComposedStructure component, ProvidedRole outerRole) {
        return component.getConnectors__ComposedStructure().stream().filter(ProvidedDelegationConnector.class::isInstance).map(ProvidedDelegationConnector.class::cast).filter(it -> it.getOuterProvidedRole_ProvidedDelegationConnector().equals(outerRole)).findFirst();
    }

    public static Optional<AssemblyContext> findAssemblyContext(FlowGraphCollection flowGraphs, String id) {
        List<Deque<AssemblyContext>> contexts = PCMQueryUtils.findAllAssemblyContexts(flowGraphs);
        List allContexts = contexts.stream().flatMap(Collection::stream).toList();
        return allContexts.stream().filter(it -> EcoreUtil.getID((EObject)it).equals(id)).findFirst();
    }

    public static Optional<? extends Entity> findAction(FlowGraphCollection flowGraphs, String id) {
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<AbstractPCMVertex> candidates = transposeFlowGraph.getVertices().stream().map(AbstractPCMVertex.class::cast).filter(it -> EcoreUtil.getID(it.getReferencedElement()).equals(id)).toList();
            if (candidates.isEmpty()) continue;
            return candidates.stream().map(AbstractPCMVertex::getReferencedElement).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    public static Optional<OperationInterface> findInterface(ResourceProvider resourceProvider, String id) {
        return PCMQueryUtils.lookupRepositoryModel(resourceProvider).getInterfaces__Repository().stream().filter(it -> it.getId().equals(id)).filter(OperationInterface.class::isInstance).map(OperationInterface.class::cast).findFirst();
    }

    public static Optional<OperationSignature> findSignature(ResourceProvider resourceProvider, String id) {
        return PCMQueryUtils.lookupRepositoryModel(resourceProvider).getInterfaces__Repository().stream().filter(OperationInterface.class::isInstance).map(OperationInterface.class::cast).map(OperationInterface::getSignatures__OperationInterface).flatMap(Collection::stream).filter(it -> it.getId().equals(id)).findFirst();
    }

    public static Optional<Connector> findConnector(ResourceProvider resourceProvider, String id) {
        return PCMQueryUtils.lookupSystemModel(resourceProvider).getConnectors__ComposedStructure().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    public static Optional<ResourceContainer> findResourceContainer(ResourceProvider resourceProvider, String id) {
        return PCMQueryUtils.lookupResourceEnvironmentModel(resourceProvider).getResourceContainer_ResourceEnvironment().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    public Optional<UsageScenario> findUsageScenario(PCMResourceProvider resourceProvider, String id) {
        return PCMQueryUtils.lookupUsageModel(resourceProvider).getUsageScenario_UsageModel().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    public static List<SEFFPCMVertex<?>> findStartActionsOfAssemblyContext(FlowGraphCollection flowGraphs, AssemblyContext component) {
        ArrayList matches = new ArrayList();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<SEFFPCMVertex> candidates = transposeFlowGraph.getVertices().stream().map(AbstractPCMVertex.class::cast).filter(it -> it instanceof SEFFPCMVertex).filter(it -> it.getReferencedElement() instanceof StartAction).filter(it -> it.getContext().contains(component)).map(it -> (SEFFPCMVertex)((Object)it)).toList();
            matches.addAll(candidates);
        }
        return matches;
    }

    public static List<AbstractPCMVertex<?>> findProcessesWithAction(FlowGraphCollection flowGraphs, Entity action) {
        ArrayList matches = new ArrayList();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<AbstractPCMVertex> candidates = transposeFlowGraph.getVertices().stream().map(AbstractPCMVertex.class::cast).filter(it -> it.getReferencedElement().equals(action)).map(it -> it).toList();
            matches.addAll(candidates);
        }
        return matches;
    }

    public static List<CallingUserPCMVertex> findEntryLevelSystemCallsViaInterface(FlowGraphCollection flowGraphs, OperationInterface operationInterface) {
        ArrayList<CallingUserPCMVertex> matches = new ArrayList<CallingUserPCMVertex>();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<CallingUserPCMVertex> entryLevelSystemCalls = transposeFlowGraph.getVertices().stream().filter(CallingUserPCMVertex.class::isInstance).map(CallingUserPCMVertex.class::cast).toList();
            List<CallingUserPCMVertex> entryLevelSystemCallsCandidates = entryLevelSystemCalls.stream().filter(it -> operationInterface.getSignatures__OperationInterface().contains((Object)((EntryLevelSystemCall)it.getReferencedElement()).getOperationSignature__EntryLevelSystemCall())).toList();
            matches.addAll(entryLevelSystemCallsCandidates);
        }
        return matches;
    }

    public static List<CallingUserPCMVertex> findEntryLevelSystemCallsViaSignature(FlowGraphCollection flowGraphs, OperationSignature signature) {
        List<CallingUserPCMVertex> candidates = PCMQueryUtils.findEntryLevelSystemCallsViaInterface(flowGraphs, signature.getInterface__OperationSignature());
        return candidates.stream().filter(it -> ((EntryLevelSystemCall)it.getReferencedElement()).getOperationSignature__EntryLevelSystemCall().equals(signature)).toList();
    }

    public static List<CallingSEFFPCMVertex> findExternalCallsViaInterface(FlowGraphCollection flowGraphs, OperationInterface operationInterface) {
        ArrayList<CallingSEFFPCMVertex> matches = new ArrayList<CallingSEFFPCMVertex>();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<CallingSEFFPCMVertex> externalCalls = transposeFlowGraph.getVertices().stream().filter(CallingSEFFPCMVertex.class::isInstance).map(CallingSEFFPCMVertex.class::cast).toList();
            List<CallingSEFFPCMVertex> externalCallCandidates = externalCalls.stream().filter(it -> operationInterface.getSignatures__OperationInterface().contains((Object)((ExternalCallAction)it.getReferencedElement()).getCalledService_ExternalService())).toList();
            matches.addAll(externalCallCandidates);
        }
        return matches;
    }

    public static List<CallingSEFFPCMVertex> findExternalCallsViaSignature(FlowGraphCollection flowGraphs, OperationSignature signature) {
        List<CallingSEFFPCMVertex> candidates = PCMQueryUtils.findExternalCallsViaInterface(flowGraphs, signature.getInterface__OperationSignature());
        return candidates.stream().filter(it -> ((ExternalCallAction)it.getReferencedElement()).getCalledService_ExternalService().equals(signature)).toList();
    }

    public static List<SEFFPCMVertex<?>> findStartActionsOfSEFFsThatImplement(FlowGraphCollection flowGraphs, OperationInterface operationInterface) {
        ArrayList matches = new ArrayList();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<SEFFPCMVertex> startActions = transposeFlowGraph.getVertices().stream().map(AbstractPCMVertex.class::cast).filter(it -> it instanceof SEFFPCMVertex).filter(it -> it.getReferencedElement() instanceof StartAction).map(it -> (SEFFPCMVertex)((Object)it)).toList();
            for (SEFFPCMVertex action : startActions) {
                ResourceDemandingSEFF seff;
                Signature signature;
                EObject eObject = ((AbstractAction)action.getReferencedElement()).eContainer();
                if (!(eObject instanceof ResourceDemandingSEFF) || !((signature = (seff = (ResourceDemandingSEFF)eObject).getDescribedService__SEFF()) instanceof OperationSignature)) continue;
                OperationSignature operationSignature = (OperationSignature)signature;
                if (!operationInterface.getSignatures__OperationInterface().contains((Object)operationSignature)) continue;
                matches.add(action);
            }
        }
        return matches;
    }

    public static List<SEFFPCMVertex<?>> findStartActionsOfSEFFsThatImplement(FlowGraphCollection flowGraphs, OperationSignature signature) {
        List<SEFFPCMVertex<?>> actionsThatImplementInterface = PCMQueryUtils.findStartActionsOfSEFFsThatImplement(flowGraphs, signature.getInterface__OperationSignature());
        ArrayList matches = new ArrayList();
        for (SEFFPCMVertex<?> action : actionsThatImplementInterface) {
            ResourceDemandingSEFF seff;
            EObject eObject = ((AbstractAction)action.getReferencedElement()).eContainer();
            if (!(eObject instanceof ResourceDemandingSEFF) || !signature.equals((seff = (ResourceDemandingSEFF)eObject).getDescribedService__SEFF())) continue;
            matches.add(action);
        }
        return matches;
    }

    public static List<PCMTransposeFlowGraph> findTransposeFlowGraphsWithElement(FlowGraphCollection flowGraphs, AbstractPCMVertex<?> element) {
        return flowGraphs.getTransposeFlowGraphs().stream().filter(PCMTransposeFlowGraph.class::isInstance).filter(it -> it.getVertices().contains(element)).map(PCMTransposeFlowGraph.class::cast).toList();
    }

    private static List<Deque<AssemblyContext>> findAllAssemblyContexts(FlowGraphCollection flowGraphs) {
        ArrayList<Deque<AssemblyContext>> allContexts = new ArrayList<Deque<AssemblyContext>>();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            for (AbstractPCMVertex vertex : transposeFlowGraph.getVertices().stream().filter(AbstractPCMVertex.class::isInstance).map(AbstractPCMVertex.class::cast).toList()) {
                allContexts.add(vertex.getContext());
            }
        }
        return allContexts;
    }

    public List<? extends AbstractPCMVertex<?>> findProcessesThatRepresentResourceContainerOrUsageScenario(FlowGraphCollection flowGraphs, PCMResourceProvider resourceProvider, Entity actor) {
        if (actor instanceof UsageScenario) {
            UsageScenario usageScenario = (UsageScenario)actor;
            ArrayList<CallingUserPCMVertex> matches = new ArrayList<CallingUserPCMVertex>();
            for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
                List<CallingUserPCMVertex> callingUserActions = transposeFlowGraph.getVertices().stream().filter(CallingUserPCMVertex.class::isInstance).map(CallingUserPCMVertex.class::cast).toList();
                List<CallingUserPCMVertex> candidates = callingUserActions.stream().filter(it -> ((EntryLevelSystemCall)it.getReferencedElement()).getScenarioBehaviour_AbstractUserAction().getUsageScenario_SenarioBehaviour().equals(usageScenario)).toList();
                matches.addAll(candidates);
            }
            return matches;
        }
        if (actor instanceof ResourceContainer) {
            ResourceContainer resourceContainer = (ResourceContainer)actor;
            Allocation allocationModel = PCMQueryUtils.lookupAllocationModel(resourceProvider);
            List<AssemblyContext> contextsDeployedOnResource = allocationModel.getAllocationContexts_Allocation().stream().filter(it -> it.getResourceContainer_AllocationContext().equals(resourceContainer)).map(AllocationContext::getAssemblyContext_AllocationContext).toList();
            ArrayList<SEFFPCMVertex> matches = new ArrayList<SEFFPCMVertex>();
            for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
                List<SEFFPCMVertex> candidates = transposeFlowGraph.getVertices().stream().filter(SEFFPCMVertex.class::isInstance).map(it -> (SEFFPCMVertex)((Object)it)).filter(it -> it.getContext().stream().anyMatch(contextsDeployedOnResource::contains)).toList();
                matches.addAll(candidates);
            }
            return matches;
        }
        throw new IllegalArgumentException("Actor must be an usage scenario or a resource container.");
    }

    private static <T extends NamedElement> T lookupPCMModel(ResourceProvider resourceProvider, EClass eclazz, Class<T> clazz) {
        Objects.requireNonNull(eclazz);
        Objects.requireNonNull(clazz);
        List<NamedElement> allPCMModelsOfGivenType = resourceProvider.lookupToplevelElement(eclazz).stream().filter(clazz::isInstance).map(clazz::cast).toList();
        if (!allPCMModelsOfGivenType.isEmpty()) {
            return (T)allPCMModelsOfGivenType.get(0);
        }
        throw new IllegalStateException(String.format("None or more than one model of type %s found in the loaded resources.", clazz.getSimpleName()));
    }

    private static Repository lookupRepositoryModel(ResourceProvider resourceProvider) {
        return PCMQueryUtils.lookupPCMModel(resourceProvider, RepositoryPackage.eINSTANCE.getRepository(), Repository.class);
    }

    private static System lookupSystemModel(ResourceProvider resourceProvider) {
        return PCMQueryUtils.lookupPCMModel(resourceProvider, SystemPackage.eINSTANCE.getSystem(), System.class);
    }

    private static ResourceEnvironment lookupResourceEnvironmentModel(ResourceProvider resourceProvider) {
        return PCMQueryUtils.lookupPCMModel(resourceProvider, ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment(), ResourceEnvironment.class);
    }

    private static Allocation lookupAllocationModel(PCMResourceProvider resourceProvider) {
        return resourceProvider.getAllocation();
    }

    private static UsageModel lookupUsageModel(PCMResourceProvider resourceProvider) {
        return resourceProvider.getUsageModel();
    }

    public static List<StartAction> findStartActionsOfBranchAction(FlowGraphCollection flowGraphs, String id) {
        ArrayList<StartAction> matches = new ArrayList<StartAction>();
        for (AbstractTransposeFlowGraph transposeFlowGraph : flowGraphs.getTransposeFlowGraphs()) {
            List<AbstractPCMVertex> startActionElements = transposeFlowGraph.getVertices().stream().map(AbstractPCMVertex.class::cast).filter(it -> it instanceof SEFFPCMVertex).filter(it -> it.getReferencedElement() instanceof StartAction).toList();
            for (AbstractPCMVertex vertex : startActionElements) {
                Optional<BranchAction> branchAction = PCMQueryUtils.findParentOfType(vertex.getReferencedElement(), BranchAction.class, false);
                if (!branchAction.isPresent() || !branchAction.get().getId().equals(id)) continue;
                matches.add((StartAction)vertex.getReferencedElement());
            }
        }
        return matches;
    }
}

