/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingOperator implements Enumerator
{
    CHECK_ONLY(0, "CHECK_ONLY", "CHECK_ONLY"),
    CREATE(1, "CREATE", "CREATE"),
    DESTROY(2, "DESTROY", "DESTROY");

    public static final int CHECK_ONLY_VALUE = 0;
    public static final int CREATE_VALUE = 1;
    public static final int DESTROY_VALUE = 2;
    private static final BindingOperator[] VALUES_ARRAY;
    public static final List<BindingOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingOperator[]{CHECK_ONLY, CREATE, DESTROY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingOperator get(int value) {
        switch (value) {
            case 0: {
                return CHECK_ONLY;
            }
            case 1: {
                return CREATE;
            }
            case 2: {
                return DESTROY;
            }
        }
        return null;
    }

    private BindingOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

