/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.services;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.ui.PlatformUI;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.PCMRandomVariable;

public class PCMServices {
    private static final String PARAMETER_VALUE_LITERAL_DIALOG_TITLE = "Enter value literal";
    private static final String PARAMETER_VALUE_LITERAL_DIALOG_MESSAGE = "Please enter a literal to set the parameter";

    public Collection<StereotypeApplication> getStereotypeApplications(EObject eObject) {
        return StereotypeAPI.getStereotypeApplications((EObject)eObject);
    }

    public Collection<StereotypeApplication> getATStereotypeApplications(EObject eObject) {
        return this.getStereotypeApplications(eObject).stream().filter(ArchitecturalTemplateAPI::isArchitecturalTemplateStereotypeApplication).collect(Collectors.toList());
    }

    public boolean isRole(StereotypeApplication stereotypeApplication) {
        return ArchitecturalTemplateAPI.isRole((Stereotype)stereotypeApplication.getStereotype());
    }

    public boolean isSystemRole(StereotypeApplication stereotypeApplication) {
        return ArchitecturalTemplateAPI.isSystemRole((Stereotype)stereotypeApplication.getStereotype());
    }

    public void queryAndSetParameterValue(EStructuralFeature parameter, EObject owningEObject) {
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PARAMETER_VALUE_LITERAL_DIALOG_TITLE, PARAMETER_VALUE_LITERAL_DIALOG_MESSAGE, null, null);
        if (inputDialog.open() == 0) {
            this.setParameterValue(parameter, owningEObject, inputDialog.getValue());
        }
    }

    public void setParameterValue(EStructuralFeature parameter, EObject owningEObject, String valueLiteral) {
        EClassifier eType = parameter.getEType();
        Object value = null;
        if (valueLiteral == null && eType != null) {
            value = parameter.isMany() ? null : eType.getDefaultValue();
        } else if (eType instanceof EDataType) {
            EFactory factory = eType.getEPackage().getEFactoryInstance();
            EDataType eDataType = (EDataType)eType;
            if (eDataType.isSerializable()) {
                try {
                    value = factory.createFromString(eDataType, valueLiteral);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        owningEObject.eSet(parameter, value);
    }

    public Collection<EStructuralFeature> getParameters(Stereotype stereotype) {
        return StereotypeAPI.getParameters((Stereotype)stereotype);
    }

    public Collection<StereotypeApplication> getRoleApplications(EObject eObject) {
        return ArchitecturalTemplateAPI.getRoleApplications((EObject)eObject);
    }

    public Collection<StereotypeApplication> getStereotypeApplicationsWithoutRoles(EObject eObject) {
        return ArchitecturalTemplateAPI.getATStereotypeApplicationsWithoutRoles((EObject)eObject);
    }

    public Collection<ProfileImport> getATProfileImports(EObject eObject) {
        return ArchitecturalTemplateAPI.getATProfileImports((EObject)eObject);
    }

    public boolean hasRoles(EObject object) {
        return ArchitecturalTemplateAPI.hasRoles((EObject)object);
    }

    public EObject editPCMRandomVariable(EObject pcmRandomVariable, String expressionString) {
        if (!(pcmRandomVariable instanceof PCMRandomVariable)) {
            return null;
        }
        ((PCMRandomVariable)pcmRandomVariable).setSpecification(expressionString);
        return pcmRandomVariable;
    }

    public DSemanticDiagram getSemanticDiagram(EObject containerView) {
        EObject container = containerView;
        while (!(container instanceof DSemanticDiagram)) {
            container = container.eContainer();
        }
        return (DSemanticDiagram)container;
    }

    public EObject copyEObject(EObject eObject) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject copy = copier.copy(eObject);
        copier.copyReferences();
        return copy;
    }

    public Identifier copyIdentifier(Identifier eObject) {
        Identifier copy = (Identifier)this.copyEObject((EObject)eObject);
        copy.setId(EcoreUtil.generateUUID());
        TreeIterator it = copy.eAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!(o instanceof Identifier)) continue;
            ((Identifier)o).setId(EcoreUtil.generateUUID());
        }
        return copy;
    }
}

