/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.facade;

import de.mdelab.sdm.interpreter.core.facade.EActivityNodeType;
import de.mdelab.sdm.interpreter.core.facade.IActivityNodeFacade;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.JunctionNode;
import org.storydriven.storydiagrams.activities.StatementNode;
import org.storydriven.storydiagrams.activities.StoryNode;

public abstract class StoryDrivenActivityNodeFacade
implements IActivityNodeFacade<ActivityNode> {
    public EActivityNodeType getActivityNodeType(ActivityNode activityNode) {
        assert (activityNode != null);
        if (activityNode instanceof StoryNode) {
            return EActivityNodeType.STORY_NODE;
        }
        if (activityNode instanceof StatementNode) {
            return EActivityNodeType.STATEMENT_NODE;
        }
        if (activityNode instanceof JunctionNode) {
            return EActivityNodeType.DECISION_NODE;
        }
        if (activityNode instanceof ActivityFinalNode) {
            return EActivityNodeType.ACTIVITY_FINAL_NODE;
        }
        if (activityNode instanceof InitialNode) {
            return EActivityNodeType.NON_EXECUTABLE_NODE;
        }
        if (activityNode instanceof ActivityCallNode) {
            return EActivityNodeType.CUSTOM_NODE;
        }
        throw new UnsupportedOperationException("Activity nodes of type '" + activityNode.eClass().getName() + "' are not yet supported. Extend the getActivityNodeType() operation in StoryDrivenActivityNodeFacade to return CUSTOM_NODE for this node type and provide an appropriate implementation in StoryDrivenInterpreter.executeCustomNode() to execute these nodes.");
    }

    public String getName(ActivityNode activityNode) {
        assert (activityNode != null);
        return activityNode.getName();
    }
}

