/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.patternmatcher;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreterManager;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.ECheckResult;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.EMatchType;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchState;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPartBasedMatcher;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.interpreter.patternmatcher.StoryDrivenLinkVariableMatchState;
import org.storydriven.storydiagrams.interpreter.patternmatcher.StoryDrivenPatternPart;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PatternsPackage;

public class StoryDrivenLinkVariablePatternPart
extends StoryDrivenPatternPart<AbstractVariable, LinkVariable> {
    public StoryDrivenLinkVariablePatternPart(PatternPartBasedMatcher<?, ?, ?, ?, AbstractVariable, AbstractLinkVariable, EClassifier, ?, Expression> patternMatcher, LinkVariable link) {
        super(patternMatcher, (AbstractLinkVariable)link, new AbstractVariable[]{link.getSource(), link.getTarget()});
    }

    @Override
    protected EMatchType doGetMatchType() {
        switch (((LinkVariable)this.link).getBindingOperator()) {
            case CHECK_ONLY: {
                switch (((LinkVariable)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        return EMatchType.MANDATORY;
                    }
                }
            }
            case CREATE: {
                switch (((LinkVariable)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.OPTIONAL;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            case DESTROY: {
                switch (((LinkVariable)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doCreateLink() {
        Variable sourceVariable = this.patternMatcher.getVariablesScope().getVariable(((LinkVariable)this.link).getSource().getName());
        Variable targetVariable = this.patternMatcher.getVariablesScope().getVariable(((LinkVariable)this.link).getTarget().getName());
        assert (sourceVariable != null);
        assert (targetVariable != null);
        assert (sourceVariable.getValue() instanceof EObject);
        EObject sourceEObject = (EObject)sourceVariable.getValue();
        if (!((LinkVariable)this.link).getTargetEnd().isMany()) {
            sourceEObject.eSet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd(), targetVariable.getValue());
        } else if (!((LinkVariable)this.link).eIsSet((EStructuralFeature)PatternsPackage.eINSTANCE.getLinkVariable_QualifierExpression())) {
            ((Collection)sourceEObject.eGet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd())).add(targetVariable.getValue());
        } else {
            ExpressionInterpreterManager expressionManager = this.patternMatcher.getExpressionInterpreterManager();
            try {
                Variable qualifierVariable = expressionManager.evaluateExpression((Object)((LinkVariable)this.link).getQualifierExpression(), null, null, this.patternMatcher.getVariablesScope());
                assert (qualifierVariable.getValue() instanceof String);
                String qualifier = (String)qualifierVariable.getValue();
                EcoreEMap map = (EcoreEMap)sourceEObject.eGet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd());
                if (!map.containsKey((Object)qualifier)) {
                    map.put((Object)qualifier, (Object)new BasicEList());
                }
                EList list = (EList)map.get((Object)qualifier);
                list.add((Object)((EObject)targetVariable.getValue()));
            }
            catch (SDMException e) {
                throw new RuntimeException(e);
            }
        }
        this.patternMatcher.getNotificationEmitter().instanceLinkCreated((Object)((LinkVariable)this.link).getSource(), (Object)sourceEObject, (Object)this.link, (Object)((LinkVariable)this.link).getTarget(), targetVariable.getValue(), this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
    }

    @Override
    protected void doDestroyLink(Map<AbstractVariable, Object> deletedObjects) {
        Variable targetVariable;
        Variable sourceVariable;
        assert (((LinkVariable)this.link).getBindingOperator() == BindingOperator.DESTROY);
        ObjectVariable sourceVar = ((LinkVariable)this.link).getSource();
        AbstractVariable targetVar = ((LinkVariable)this.link).getTarget();
        assert (deletedObjects.get(sourceVar) == null || deletedObjects.get(sourceVar) instanceof EObject);
        EObject sourceInstanceObject = (EObject)deletedObjects.get(sourceVar);
        Object targetInstanceObject = deletedObjects.get(targetVar);
        if (sourceInstanceObject == null && (sourceVariable = this.patternMatcher.getVariablesScope().getVariable(sourceVar.getName())) != null) {
            assert (sourceVariable.getValue() instanceof EObject);
            sourceInstanceObject = (EObject)sourceVariable.getValue();
        }
        if (targetInstanceObject == null && (targetVariable = this.patternMatcher.getVariablesScope().getVariable(targetVar.getName())) != null) {
            targetInstanceObject = targetVariable.getValue();
        }
        if (sourceInstanceObject != null && targetInstanceObject != null) {
            if (!((LinkVariable)this.link).getTargetEnd().isMany()) {
                sourceInstanceObject.eSet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd(), null);
            } else {
                ((Collection)sourceInstanceObject.eGet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd())).remove(targetInstanceObject);
            }
            this.patternMatcher.getNotificationEmitter().instanceLinkDestroyed((Object)sourceVar, (Object)sourceInstanceObject, (Object)this.link, (Object)targetVar, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        }
    }

    public ECheckResult check() throws SDMException {
        ObjectVariable source = ((LinkVariable)this.link).getSource();
        AbstractVariable target = ((LinkVariable)this.link).getTarget();
        if (((LinkVariable)this.link).getBindingOperator() != BindingOperator.CREATE && this.patternMatcher.isBound((Object)source) && this.patternMatcher.isBound((Object)target)) {
            VariablesScope variablesScope = this.patternMatcher.getVariablesScope();
            Variable sourceVariable = variablesScope.getVariable(source.getName());
            Variable targetVariable = variablesScope.getVariable(target.getName());
            if (sourceVariable != null && targetVariable != null) {
                assert (sourceVariable.getValue() != null);
                assert (targetVariable.getValue() != null);
                assert (sourceVariable.getValue() instanceof EObject);
                EObject sourceInstanceObject = (EObject)sourceVariable.getValue();
                Object targetInstanceObject = targetVariable.getValue();
                EReference eStructuralFeature = ((LinkVariable)this.link).getTargetEnd();
                if (!eStructuralFeature.isMany()) {
                    if (sourceInstanceObject.eGet((EStructuralFeature)eStructuralFeature) == targetInstanceObject) {
                        this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                        return ECheckResult.OK;
                    }
                    this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                    return ECheckResult.FAIL;
                }
                if (!((LinkVariable)this.link).eIsSet((EStructuralFeature)PatternsPackage.eINSTANCE.getLinkVariable_QualifierExpression())) {
                    if (((Collection)sourceInstanceObject.eGet((EStructuralFeature)eStructuralFeature)).contains(targetInstanceObject)) {
                        this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                        return ECheckResult.OK;
                    }
                    this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                    return ECheckResult.FAIL;
                }
                ExpressionInterpreterManager expressionManager = this.patternMatcher.getExpressionInterpreterManager();
                try {
                    EList list;
                    Variable qualifierVariable = expressionManager.evaluateExpression((Object)((LinkVariable)this.link).getQualifierExpression(), null, null, this.patternMatcher.getVariablesScope());
                    assert (qualifierVariable.getValue() instanceof String);
                    String qualifier = (String)qualifierVariable.getValue();
                    EcoreEMap map = (EcoreEMap)sourceInstanceObject.eGet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd());
                    if (map.containsKey((Object)qualifier) && (list = (EList)map.get((Object)qualifier)).contains(targetInstanceObject)) {
                        this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                        return ECheckResult.OK;
                    }
                    this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)source, (Object)sourceInstanceObject, (Object)this.link, (Object)target, targetInstanceObject, variablesScope, (Notifier)this.patternMatcher);
                    return ECheckResult.FAIL;
                }
                catch (SDMException e) {
                    throw new RuntimeException(e);
                }
            }
            return ECheckResult.UNKNOWN;
        }
        if (((LinkVariable)this.link).getBindingOperator() == BindingOperator.CREATE && ((LinkVariable)this.link).getBindingSemantics() != BindingSemantics.OPTIONAL) {
            return ECheckResult.OK;
        }
        return ECheckResult.UNKNOWN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(MatchState matchState) throws SDMException {
        assert (matchState instanceof StoryDrivenLinkVariableMatchState);
        StoryDrivenLinkVariableMatchState ms = (StoryDrivenLinkVariableMatchState)matchState;
        ObjectVariable sourceSpo = ((LinkVariable)this.link).getSource();
        AbstractVariable targetSpo = ((LinkVariable)this.link).getTarget();
        assert (this.patternMatcher.isBound((Object)sourceSpo) || this.patternMatcher.isBound((Object)targetSpo));
        assert (!this.patternMatcher.isBound((Object)sourceSpo) || !this.patternMatcher.isBound((Object)targetSpo));
        if (this.patternMatcher.isBound((Object)sourceSpo)) {
            EObject sourceInstanceObject = (EObject)this.patternMatcher.getInstanceObject((Object)sourceSpo);
            return this.matchTargetObject(ms, (AbstractVariable)sourceSpo, targetSpo, sourceInstanceObject, (EStructuralFeature)((LinkVariable)this.link).getTargetEnd());
        }
        sourceSpo = ((LinkVariable)this.link).getTarget();
        targetSpo = ((LinkVariable)this.link).getSource();
        EObject sourceInstanceObject = (EObject)this.patternMatcher.getInstanceObject((Object)sourceSpo);
        if (!(((LinkVariable)this.link).getTargetEnd() instanceof EReference)) throw new UnsupportedOperationException();
        EReference eReference = ((LinkVariable)this.link).getTargetEnd();
        if (eReference.getEOpposite() != null) {
            return this.matchTargetObject(ms, (AbstractVariable)sourceSpo, targetSpo, sourceInstanceObject, (EStructuralFeature)eReference.getEOpposite());
        }
        if (!eReference.isContainment()) throw new UnsupportedOperationException();
        this.patternMatcher.getNotificationEmitter().traversingLink((Object)this.link, (Object)sourceSpo, (Object)sourceInstanceObject, (Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        EObject targetInstanceObject = sourceInstanceObject.eContainer();
        if (this.patternMatcher.matchStoryPatternObject((Object)targetSpo, (Object)targetInstanceObject) && (!eReference.isMany() && sourceInstanceObject.eContainer().eGet((EStructuralFeature)eReference) == sourceInstanceObject || eReference.isMany() && ((Collection)sourceInstanceObject.eContainer().eGet((EStructuralFeature)eReference)).contains(sourceInstanceObject))) {
            this.patternMatcher.getNotificationEmitter().storyPatternObjectBound((Object)targetSpo, (Object)targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
            return true;
        }
        this.patternMatcher.getNotificationEmitter().storyPatternObjectNotBound((Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        return false;
    }

    public int calculateMatchingCost() {
        assert (!this.patternMatcher.isBound((Object)((LinkVariable)this.link).getSource()) || !this.patternMatcher.isBound((Object)((LinkVariable)this.link).getTarget()));
        if (this.patternMatcher.isBound((Object)((LinkVariable)this.link).getSource())) {
            if (!((LinkVariable)this.link).getTargetEnd().isMany()) {
                return 1;
            }
            Variable sourceVariable = this.patternMatcher.getVariablesScope().getVariable(((LinkVariable)this.link).getSource().getName());
            assert (sourceVariable.getValue() instanceof EObject);
            EObject sourceEObject = (EObject)sourceVariable.getValue();
            return ((Collection)sourceEObject.eGet((EStructuralFeature)((LinkVariable)this.link).getTargetEnd())).size();
        }
        if (this.patternMatcher.isBound((Object)((LinkVariable)this.link).getTarget())) {
            EReference eReference = ((LinkVariable)this.link).getTargetEnd();
            if (eReference.isContainment()) {
                return 2;
            }
            if (eReference.getEOpposite() != null) {
                if (!eReference.getEOpposite().isMany()) {
                    return 1;
                }
                Variable targetVariable = this.patternMatcher.getVariablesScope().getVariable(((LinkVariable)this.link).getTarget().getName());
                assert (targetVariable.getValue() instanceof EObject);
                EObject targetEObject = (EObject)targetVariable.getValue();
                return ((Collection)targetEObject.eGet((EStructuralFeature)eReference.getEOpposite())).size();
            }
            return -1;
        }
        return -1;
    }

    public MatchState createMatchState() {
        return new StoryDrivenLinkVariableMatchState();
    }

    private boolean matchTargetObject(StoryDrivenLinkVariableMatchState<Iterator<Object>> matchState, AbstractVariable sourceSpo, AbstractVariable targetSpo, EObject sourceInstanceObject, EStructuralFeature feature) throws SDMException {
        assert (matchState != null);
        assert (sourceSpo != null);
        assert (targetSpo != null);
        assert (sourceInstanceObject != null);
        assert (feature != null);
        this.patternMatcher.getNotificationEmitter().traversingLink((Object)this.link, (Object)sourceSpo, (Object)sourceInstanceObject, (Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        if (!feature.isMany()) {
            Object targetInstanceObject = sourceInstanceObject.eGet(feature);
            if (this.patternMatcher.matchStoryPatternObject((Object)targetSpo, targetInstanceObject)) {
                this.patternMatcher.getNotificationEmitter().storyPatternObjectBound((Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                return true;
            }
        } else {
            Iterator<Object> linkIterator = matchState.getLinkIterator();
            if (linkIterator == null || sourceInstanceObject != matchState.getSourceInstanceObject()) {
                if (((LinkVariable)this.link).eIsSet((EStructuralFeature)PatternsPackage.eINSTANCE.getLinkVariable_QualifierExpression())) {
                    Variable qualifierVariable = this.patternMatcher.getExpressionInterpreterManager().evaluateExpression((Object)((LinkVariable)this.link).getQualifierExpression(), null, null, this.patternMatcher.getVariablesScope());
                    assert (qualifierVariable.getValue() instanceof String);
                    String qualifier = (String)qualifierVariable.getValue();
                    EMap map = (EMap)sourceInstanceObject.eGet(feature);
                    EList targetInstanceObject = (EList)map.get((Object)qualifier);
                    if (targetInstanceObject == null) {
                        targetInstanceObject = new BasicEList();
                    }
                    linkIterator = targetInstanceObject.iterator();
                } else {
                    linkIterator = ((Collection)sourceInstanceObject.eGet(feature)).iterator();
                }
                matchState.setLinkIterator(linkIterator);
                matchState.setSourceInstanceObject(sourceInstanceObject);
            }
            while (linkIterator.hasNext()) {
                Object targetInstanceObject = linkIterator.next();
                if (!this.patternMatcher.matchStoryPatternObject((Object)targetSpo, targetInstanceObject)) continue;
                this.patternMatcher.getNotificationEmitter().storyPatternObjectBound((Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                return true;
            }
        }
        this.patternMatcher.getNotificationEmitter().storyPatternObjectNotBound((Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        return false;
    }
}

