/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.patternmatcher;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.EMatchType;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPart;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPartBasedMatcher;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.ObjectVariable;

public abstract class StoryDrivenPatternPart<AV extends AbstractVariable, ALV extends AbstractLinkVariable>
extends PatternPart<AbstractVariable, AbstractLinkVariable, EClassifier, Expression> {
    protected boolean isCreate = false;
    protected boolean isDestroy = false;
    protected final ALV link;
    protected final AV[] variables;
    protected final EMatchType matchType;

    public StoryDrivenPatternPart(PatternPartBasedMatcher<?, ?, ?, ?, AbstractVariable, AbstractLinkVariable, EClassifier, ?, Expression> patternMatcher, ALV link, AV[] variables) {
        super(patternMatcher);
        assert (variables.length > 0);
        assert (link != null || variables.length == 1);
        this.link = link;
        this.variables = variables;
        this.matchType = this.doGetMatchType();
        if (link != null) {
            switch (link.getBindingOperator()) {
                case CREATE: {
                    this.isCreate = true;
                    break;
                }
                case DESTROY: {
                    this.isDestroy = true;
                    break;
                }
            }
        }
        AV[] AVArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            AV av = AVArray[n2];
            if (av instanceof ObjectVariable) {
                switch (((ObjectVariable)av).getBindingOperator()) {
                    case CREATE: {
                        this.isCreate = true;
                        break;
                    }
                    case DESTROY: {
                        this.isDestroy = true;
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public AV[] getStoryPatternObjects() {
        return this.variables;
    }

    public void createLinks() throws SDMException {
        if (this.isCreate) {
            this.doCreateLink();
        }
    }

    public void createObjects() throws SDMException {
        if (this.isCreate) {
            AV[] AVArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                AV var = AVArray[n2];
                if (var instanceof ObjectVariable && ((ObjectVariable)var).getBindingOperator() == BindingOperator.CREATE && !this.patternMatcher.getVariablesScope().variableExists(var.getName())) {
                    ObjectVariable objectVariable = (ObjectVariable)var;
                    EFactory factory = objectVariable.getClassifier().getEPackage().getEFactoryInstance();
                    EObject eObject = factory.create(objectVariable.getClassifier());
                    this.patternMatcher.getVariablesScope().createVariable(objectVariable.getName(), (Object)objectVariable.getClassifier(), (Object)eObject);
                    this.patternMatcher.getNotificationEmitter().instanceObjectCreated(var, (Object)eObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                }
                ++n2;
            }
        }
    }

    public void destroyLinks(Map<AbstractVariable, Object> deletedObjects) {
        if (this.isDestroy) {
            this.doDestroyLink(deletedObjects);
        }
    }

    public void destroyObjects() {
        if (this.isDestroy) {
            AV[] AVArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable;
                AV var = AVArray[n2];
                if (var instanceof ObjectVariable && ((ObjectVariable)var).getBindingOperator() == BindingOperator.DESTROY && (variable = this.patternMatcher.getVariablesScope().deleteVariable(var.getName())) != null) {
                    assert (variable.getValue() instanceof EObject);
                    EObject instanceObject = (EObject)variable.getValue();
                    assert (instanceObject != null);
                    EcoreUtil.delete((EObject)instanceObject, (boolean)true);
                    this.patternMatcher.getNotificationEmitter().instanceObjectDestroyed(var, (Object)instanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                }
                ++n2;
            }
        }
    }

    public EMatchType getMatchType() {
        return this.matchType;
    }

    protected abstract EMatchType doGetMatchType();

    protected abstract void doCreateLink();

    protected abstract void doDestroyLink(Map<AbstractVariable, Object> var1);
}

