/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.di.extension;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import dagger.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.builder.GraphBuilder;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.palladiosimulator.simulizar.di.extension.ExtensionComponent;
import org.palladiosimulator.simulizar.di.extension.GenericComponentFactory;

public class ExtensionComponentDependencyResolution {
    private static final Logger LOGGER = Logger.getLogger(ExtensionComponentDependencyResolution.class);
    private Set<Object> bootStrappingComponents;
    private Set<ExtensionComponent.Factory> extensionComponentFactories;
    private Set<ExtensionComponent> extensionComponents;

    public ExtensionComponentDependencyResolution(Set<Object> bootStrappingComponents, Set<ExtensionComponent.Factory> extensionComponentFactories) {
        this.bootStrappingComponents = bootStrappingComponents;
        this.extensionComponentFactories = extensionComponentFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ExtensionComponent> getExtensionComponents() {
        if (this.extensionComponents == null) {
            ExtensionComponentDependencyResolution extensionComponentDependencyResolution = this;
            synchronized (extensionComponentDependencyResolution) {
                if (this.extensionComponents == null) {
                    this.extensionComponents = this.initializeExtensionComponentSet();
                }
            }
        }
        return this.extensionComponents;
    }

    private Set<ExtensionComponent> initializeExtensionComponentSet() {
        HashMap componentProviders = new HashMap();
        HashMultimap supplierToSupportedTypes = HashMultimap.create();
        for (Object comp : this.bootStrappingComponents) {
            Streams.stream(GenericComponentFactory.getClassHierarchy(comp.getClass())).filter(cls -> cls.getAnnotation(Component.class) != null).forEach(cls -> {
                Supplier<Object> supplier = componentProviders.put(cls.getName(), () -> comp);
            });
        }
        GraphBuilder graphBuilder = DefaultDirectedGraph.createBuilder(DefaultEdge.class);
        Set<GenericComponentFactory> genericFactories = this.extensionComponentFactories.stream().map(fact -> new GenericComponentFactory((ExtensionComponent.Factory)fact)).collect(Collectors.toSet());
        genericFactories.forEach(arg_0 -> ExtensionComponentDependencyResolution.lambda$4(graphBuilder, componentProviders, (Multimap)supplierToSupportedTypes, arg_0));
        DefaultDirectedGraph componentGraph = (DefaultDirectedGraph)graphBuilder.build();
        Set missingComponents = componentGraph.vertexSet().stream().filter(v -> !componentProviders.containsKey(v)).collect(Collectors.toSet());
        Set<String> unfullfillableComponents = Streams.stream((Iterator)new BreadthFirstIterator((Graph)componentGraph, missingComponents)).collect(Collectors.toSet());
        unfullfillableComponents.forEach(arg_0 -> ExtensionComponentDependencyResolution.lambda$8(componentGraph, componentProviders, (Multimap)supplierToSupportedTypes, arg_0));
        supplierToSupportedTypes.keySet().forEach(arg_0 -> ExtensionComponentDependencyResolution.lambda$9((Multimap)supplierToSupportedTypes, componentGraph, componentProviders, arg_0));
        CycleDetector cycleDetector = new CycleDetector((Graph)componentGraph);
        if (cycleDetector.detectCycles()) {
            Set cycle = cycleDetector.findCycles();
            LOGGER.error((Object)"Detected dependency cycle:");
            cycle.forEach(cls -> LOGGER.error((Object)("Component: " + cls.toString())));
            LOGGER.error((Object)"End of dependency cycle");
            throw new IllegalStateException("Failed due to a cyclic dependency. Check the Log.");
        }
        HashSet<ExtensionComponent> resultingComponents = new HashSet<ExtensionComponent>(this.bootStrappingComponents.size() + this.extensionComponentFactories.size());
        new TopologicalOrderIterator((Graph)componentGraph).forEachRemaining(cls -> {
            componentGraph.incomingEdgesOf(cls).forEach(edge -> {
                String dependency = (String)componentGraph.getEdgeSource(edge);
                ((GenericComponentFactory)componentProviders.get(cls)).fulfillRequirement((Supplier)componentProviders.get(dependency));
            });
            Object component = ((Supplier)componentProviders.get(cls)).get();
            componentProviders.put(cls, () -> component);
            if (component instanceof ExtensionComponent && !this.bootStrappingComponents.contains(component)) {
                resultingComponents.add((ExtensionComponent)component);
            }
        });
        this.extensionComponentFactories = null;
        this.bootStrappingComponents = null;
        return resultingComponents;
    }

    private static /* synthetic */ void lambda$4(GraphBuilder graphBuilder, Map map, Multimap multimap, GenericComponentFactory gcf) {
        Set<Class<?>> requirements = gcf.getUnfullfilledRequirements();
        gcf.getProvidedComponentTypes().forEach(pct -> {
            graphBuilder.addVertex((Object)pct.getName());
            if (!map.containsKey(pct.getName())) {
                map.put(pct.getName(), gcf);
                multimap.put((Object)gcf, (Object)pct.getName());
                requirements.forEach(req -> {
                    graphBuilder.addVertex((Object)req.getName());
                    graphBuilder.addEdge((Object)req.getName(), (Object)pct.getName());
                });
            } else if (map.get(pct.getName()) instanceof GenericComponentFactory) {
                LOGGER.warn((Object)("Duplicate registration for " + pct.getName() + " skipping second one."));
            }
        });
    }

    private static /* synthetic */ void lambda$8(DefaultDirectedGraph defaultDirectedGraph, Map map, Multimap multimap, String c) {
        defaultDirectedGraph.removeVertex((Object)c);
        Supplier provider = (Supplier)map.remove(c);
        if (provider != null) {
            multimap.removeAll((Object)provider);
        }
    }

    private static /* synthetic */ void lambda$9(Multimap multimap, DefaultDirectedGraph defaultDirectedGraph, Map map, Supplier supplier) {
        Collection providedTypes = multimap.get((Object)supplier);
        String supplierIdentifier = String.valueOf(supplier.getClass().getName()) + "<" + (String)providedTypes.iterator().next() + ">";
        defaultDirectedGraph.addVertex((Object)supplierIdentifier);
        map.put(supplierIdentifier, supplier);
        providedTypes.forEach(pt -> {
            ImmutableSet outgoingEdges = ImmutableSet.copyOf((Collection)defaultDirectedGraph.outgoingEdgesOf(pt));
            outgoingEdges.forEach(edge -> {
                String target = (String)defaultDirectedGraph.getEdgeTarget(edge);
                if (!supplierIdentifier.equals(target)) {
                    defaultDirectedGraph.addEdge((Object)supplierIdentifier, (Object)target);
                }
            });
            ImmutableSet incomingEdges = ImmutableSet.copyOf((Collection)defaultDirectedGraph.incomingEdgesOf(pt));
            incomingEdges.forEach(edge -> {
                String source = (String)defaultDirectedGraph.getEdgeSource(edge);
                if (!supplierIdentifier.equals(source)) {
                    defaultDirectedGraph.addEdge((Object)source, (Object)supplierIdentifier);
                }
            });
            defaultDirectedGraph.removeAllEdges((Collection)outgoingEdges);
            defaultDirectedGraph.removeAllEdges((Collection)incomingEdges);
            defaultDirectedGraph.removeVertex(pt);
        });
    }
}

