/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.resources.ISimulatedModelEntityAccess;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.ResourceProvidedRole;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceSignature;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.seff_performance.util.SeffPerformanceSwitch;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.interpreter.ComposedStructureInnerSwitch;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RDSeffSwitchContributionFactory;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehaviorContainer;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResumptionPolicy;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;

public class RDSeffPerformanceSwitch
extends SeffPerformanceSwitch<InterpreterResult> {
    private final InterpreterDefaultContext context;
    private final IAssemblyAllocationLookup<EntityReference<ResourceContainer>> allocationLookup;
    private final ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer> rcAccess;
    private final ComposedStructureInnerSwitch.Factory composedSwitchFactory;
    private final PreInterpretationBehaviorManager pibManager;
    private final InterpreterResultHandler issueHandler;
    private final InterpreterResultMerger resultMerger;

    @AssistedInject
    public RDSeffPerformanceSwitch(@Assisted InterpreterDefaultContext context, @Assisted RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch, IAssemblyAllocationLookup<EntityReference<ResourceContainer>> allocationLookup, ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer> rcAccess, ComposedStructureInnerSwitch.Factory composedSwitchFactory, InterpreterResultHandler issueHandler, InterpreterResultMerger resultMerger, PreInterpretationBehaviorManager pibManager) {
        this.context = context;
        this.allocationLookup = allocationLookup;
        this.rcAccess = rcAccess;
        this.composedSwitchFactory = composedSwitchFactory;
        this.issueHandler = issueHandler;
        this.resultMerger = resultMerger;
        this.pibManager = pibManager;
    }

    public InterpreterResult caseParametricResourceDemand(ParametricResourceDemand parametricResourceDemand) {
        String idRequiredResourceType = parametricResourceDemand.getRequiredResource_ParametricResourceDemand().getId();
        String specification = parametricResourceDemand.getSpecification_ParametericResourceDemand().getSpecification();
        SimulatedStackframe currentStackFrame = this.context.getStack().currentStackFrame();
        Double value = (Double)StackContext.evaluateStatic((String)specification, Double.class, (SimulatedStackframe)currentStackFrame);
        String fqid = this.context.computeFQComponentID().getFQIDString();
        EntityReference rcEntity = Objects.requireNonNull((EntityReference)this.allocationLookup.getAllocatedEntity(fqid), () -> "No allocation found for assembly identified by " + fqid);
        InterpreterResult result = InterpreterResult.OK;
        for (AbstractScheduledResource r : ((AbstractSimulatedResourceContainer)this.rcAccess.getSimulatedEntity(rcEntity.getId())).getAllActiveResources().values()) {
            String resourceId = r.getName();
            if (!this.pibManager.hasContainerAlreadyBeenRegisteredForEntity(resourceId)) continue;
            PreInterpretationBehaviorContainer pibContainer = this.pibManager.getContainerForEntity(resourceId);
            InterpreterResult newResult = pibContainer.executeBehaviors(this.context);
            result = this.resultMerger.merge(result, newResult);
        }
        if (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE) {
            ((AbstractSimulatedResourceContainer)this.rcAccess.getSimulatedEntity(rcEntity.getId())).loadActiveResource(this.context.getThread(), idRequiredResourceType, value.doubleValue());
        }
        return result;
    }

    public InterpreterResult caseResourceCall(ResourceCall resourceCall) {
        ResourceInterface resourceInterface = resourceCall.getSignature__ResourceCall().getResourceInterface__ResourceSignature();
        ResourceRepository resourceRepository = resourceInterface.getResourceRepository__ResourceInterface();
        ResourceType currentResourceType = null;
        block0: for (ResourceType resourceType : resourceRepository.getAvailableResourceTypes_ResourceRepository()) {
            for (ResourceProvidedRole resourceProvidedRole : resourceType.getResourceProvidedRoles__ResourceInterfaceProvidingEntity()) {
                if (!resourceProvidedRole.getProvidedResourceInterface__ResourceProvidedRole().getId().equals(resourceInterface.getId())) continue;
                currentResourceType = resourceType;
                continue block0;
            }
        }
        ResourceSignature resourceSignature = resourceCall.getSignature__ResourceCall();
        int resourceServiceId = resourceSignature.getResourceServiceId();
        SimulatedStackframe currentStackFrame = this.context.getStack().currentStackFrame();
        Double evaluatedDemand = NumberConverter.toDouble((Object)StackContext.evaluateStatic((String)resourceCall.getNumberOfCalls__ResourceCall().getSpecification(), Double.class, (SimulatedStackframe)currentStackFrame));
        String idRequiredResourceType = currentResourceType.getId();
        EntityReference rcEntity = (EntityReference)this.allocationLookup.getAllocatedEntity(this.context.computeFQComponentID().getFQIDString());
        ((AbstractSimulatedResourceContainer)this.rcAccess.getSimulatedEntity(rcEntity.getId())).loadActiveResource(this.context.getThread(), resourceServiceId, idRequiredResourceType, evaluatedDemand.doubleValue());
        return InterpreterResult.OK;
    }

    public InterpreterResult caseInfrastructureCall(InfrastructureCall infrastructureCall) {
        SimulatedStackframe currentStackFrame = this.context.getStack().currentStackFrame();
        int repetitions = (Integer)StackContext.evaluateStatic((String)infrastructureCall.getNumberOfCalls__InfrastructureCall().getSpecification(), Integer.class, (SimulatedStackframe)currentStackFrame);
        int i = 0;
        while (i < repetitions) {
            ComposedStructureInnerSwitch composedStructureSwitch = this.composedSwitchFactory.create(this.context, (Signature)infrastructureCall.getSignature__InfrastructureCall(), (RequiredRole)infrastructureCall.getRequiredRole__InfrastructureCall());
            SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)infrastructureCall.getInputVariableUsages__CallAction());
            AssemblyContext myContext = this.context.getAssemblyContextStack().pop();
            composedStructureSwitch.doSwitch((EObject)myContext);
            this.context.getAssemblyContextStack().push(myContext);
            this.context.getStack().removeStackFrame();
            ++i;
        }
        return InterpreterResult.OK;
    }

    @AssistedFactory
    public static interface Factory
    extends RDSeffSwitchContributionFactory {
        public RDSeffPerformanceSwitch createRDSeffSwitch(InterpreterDefaultContext var1, RDSeffSwitchContributionFactory.RDSeffElementDispatcher var2);
    }
}

