/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.linking.impl;

import java.util.Optional;
import javax.inject.Inject;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.linking.ILinkingResourceRouter;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionInterpreter;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionPayloadDemandCalculator;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionSimulationStrategy;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehaviorContainer;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResumptionPolicy;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager;

public class DefaultSimuLizarTransmissionInterpreter<NodeType, PayloadType>
implements ITransmissionInterpreter<NodeType, PayloadType, InterpreterDefaultContext> {
    private ILinkingResourceRouter<NodeType, EntityReference<LinkingResource>> router;
    private ITransmissionPayloadDemandCalculator<PayloadType, Double> calculator;
    private ITransmissionSimulationStrategy<EntityReference<LinkingResource>, Double, InterpreterDefaultContext> transmissionSimulation;
    private final InterpreterResultHandler issueHandler;
    private final InterpreterResultMerger resultMerger;
    private final PreInterpretationBehaviorManager pibManager;

    @Inject
    public DefaultSimuLizarTransmissionInterpreter(ILinkingResourceRouter<NodeType, EntityReference<LinkingResource>> router, ITransmissionPayloadDemandCalculator<PayloadType, Double> calculator, ITransmissionSimulationStrategy<EntityReference<LinkingResource>, Double, InterpreterDefaultContext> transmissionSimulation, InterpreterResultHandler issueHandler, InterpreterResultMerger resultMerger, PreInterpretationBehaviorManager pibManager) {
        this.router = router;
        this.calculator = calculator;
        this.transmissionSimulation = transmissionSimulation;
        this.issueHandler = issueHandler;
        this.resultMerger = resultMerger;
        this.pibManager = pibManager;
    }

    @Override
    public InterpreterResult interpretTransmission(NodeType source, NodeType target, PayloadType payload, InterpreterDefaultContext context) {
        InterpreterResult result = InterpreterResult.OK;
        Double demand = this.calculator.calculatePayloadDemand(payload);
        Optional<Iterable<EntityReference<LinkingResource>>> links = this.router.findRoute(source, target);
        if (links.isEmpty()) {
            throw new RuntimeException("Could not determine route between nodes. This should be turned into a simulation feature.");
        }
        for (EntityReference<LinkingResource> l : links.get()) {
            String linkId = l.getId();
            if (!this.pibManager.hasContainerAlreadyBeenRegisteredForEntity(linkId)) continue;
            PreInterpretationBehaviorContainer pibContainer = this.pibManager.getContainerForEntity(linkId);
            InterpreterResult newResult = pibContainer.executeBehaviors(context);
            result = this.resultMerger.merge(result, newResult);
        }
        if (this.issueHandler.handleIssues(result) == InterpreterResumptionPolicy.CONTINUE) {
            links.get().forEach(link -> this.transmissionSimulation.simulateTransmission((EntityReference<LinkingResource>)link, demand, context));
        }
        return result;
    }
}

