/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.preinterpretation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehavior;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;

public class PreInterpretationBehaviorContainer {
    private List<PreInterpretationBehavior> behaviors;
    private final InterpreterResultMerger merger;

    @Inject
    public PreInterpretationBehaviorContainer(InterpreterResultMerger merger) {
        this.merger = merger;
        this.behaviors = new ArrayList<PreInterpretationBehavior>();
    }

    public InterpreterResult executeBehaviors(InterpreterDefaultContext context) {
        InterpreterResult result = InterpreterResult.OK;
        ImmutableList localBehaviors = ImmutableList.copyOf(this.behaviors);
        for (PreInterpretationBehavior b : localBehaviors) {
            result = this.merger.merge(result, b.execute(context));
        }
        return result;
    }

    public void addBehavior(PreInterpretationBehavior b) {
        if (!this.behaviors.contains(b)) {
            this.behaviors.add(b);
        }
    }

    public void removeBehavior(PreInterpretationBehavior b) {
        this.behaviors.remove(b);
    }

    public void removeAllBehaviors() {
        this.behaviors.clear();
    }
}

