/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.result;

import com.google.common.collect.ImmutableSet;
import org.palladiosimulator.simulizar.interpreter.result.InterpretationIssue;
import org.palladiosimulator.simulizar.interpreter.result.impl.BasicInterpreterResult;

public interface InterpreterResult {
    public static final InterpreterResult OK = new OkResult();

    public boolean hasNoIssues();

    public Iterable<InterpretationIssue> getIssues();

    public static InterpreterResult of(InterpretationIssue issue) {
        return BasicInterpreterResult.of(issue);
    }

    public static class OkResult
    implements InterpreterResult {
        @Override
        public final boolean hasNoIssues() {
            return true;
        }

        @Override
        public final Iterable<InterpretationIssue> getIssues() {
            return ImmutableSet.of();
        }
    }
}

