/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.simulizar.interpreter.EventDispatcher;
import org.palladiosimulator.simulizar.interpreter.listener.IInterpreterListener;
import org.palladiosimulator.simulizar.launcher.jobs.RunInterpreterJob;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurationLoader;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityManager;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityObserver;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

public class SimuLizarRuntimeJob
extends SequentialJob {
    private static final Logger LOGGER = Logger.getLogger(SimuLizarRuntimeJob.class);
    private final PCMPartitionManager pcmPartitionManager;
    private final EventDispatcher eventHelper;
    private final Set<IModelObserver> modelObservers;
    private final Set<IInterpreterListener> interpreterListeners;
    private final Set<AbstractReconfigurationLoader> reconfigurationLoaders;
    private final SimuLizarWorkflowConfiguration configuration;
    private final Set<RuntimeStateEntityManager> entityManagers;
    private final Set<RuntimeStateEntityObserver> entityObservers;

    @Inject
    public SimuLizarRuntimeJob(SimuLizarWorkflowConfiguration configuration, PCMPartitionManager pcmPartitionManager, EventDispatcher eventHelper, Set<IModelObserver> modelObservers, Set<IInterpreterListener> interpreterListeners, RunInterpreterJob interpreterJob, Set<AbstractReconfigurationLoader> reconfigurationLoaders, Set<RuntimeStateEntityManager> entityManagers, Set<RuntimeStateEntityObserver> entityObservers) {
        this.configuration = configuration;
        this.pcmPartitionManager = pcmPartitionManager;
        this.eventHelper = eventHelper;
        this.interpreterListeners = interpreterListeners;
        this.modelObservers = modelObservers;
        this.reconfigurationLoaders = reconfigurationLoaders;
        this.entityManagers = entityManagers;
        this.entityObservers = entityObservers;
        this.addJob((IJob)interpreterJob);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.pcmPartitionManager.initialize();
        LOGGER.debug((Object)"Load reconfigurations");
        this.reconfigurationLoaders.forEach(loader -> loader.load(this.configuration));
        LOGGER.debug((Object)"Initialize managers of internal simulation state");
        this.entityManagers.forEach(RuntimeStateEntityManager::initialize);
        LOGGER.debug((Object)"Initialize observers of internal simulation state");
        this.entityObservers.forEach(RuntimeStateEntityObserver::initialize);
        LOGGER.debug((Object)"Initialize model observers, e.g., to runtime state objects in sync with global PCM model");
        this.modelObservers.forEach(m -> m.initialize());
        LOGGER.debug((Object)"Initialize interpreter listeners.");
        this.interpreterListeners.forEach(arg_0 -> ((EventDispatcher)this.eventHelper).addObserver(arg_0));
        this.interpreterListeners.forEach(IInterpreterListener::initialize);
        this.pcmPartitionManager.startObservingPcmChanges();
        super.execute(monitor);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        LOGGER.debug((Object)"Deregister all listeners and execute cleanup code");
        this.eventHelper.removeAllListener();
        this.pcmPartitionManager.stopObservingPcmChanges();
        this.interpreterListeners.forEach(IInterpreterListener::cleanup);
        this.modelObservers.forEach(IModelObserver::unregister);
        this.entityManagers.forEach(RuntimeStateEntityManager::cleanup);
    }

    public String getName() {
        return SimuLizarRuntimeJob.class.getName();
    }
}

