/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs.extensions;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.simulizar.launcher.jobs.ModelCompletionJobContributor;
import org.palladiosimulator.simulizar.launcher.jobs.extensions.DefaultMeasuringPointRepositoryFactory;
import org.palladiosimulator.simulizar.launcher.jobs.extensions.DefaultMonitorRepositoryFactory;

public class DefaultMonitorRepositoryCompletionContributor
extends AbstractBlackboardInteractingJob<MDSDBlackboard>
implements ModelCompletionJobContributor,
Comparable<IJob> {
    private final MDSDBlackboard blackboard;

    @Inject
    public DefaultMonitorRepositoryCompletionContributor(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    @Override
    public void contribute(ModelCompletionJobContributor.Facade delegate) {
        if (this.blackboard.hasPartition("org.palladiosimulator.pcmmodels.partition") && ((ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition")).getElement(MonitorRepositoryPackage.Literals.MONITOR_REPOSITORY).isEmpty()) {
            delegate.contribute((IBlackboardInteractingJob<MDSDBlackboard>)this);
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSet resSet = ((ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition")).getResourceSet();
        MeasuringPointRepository measuringPointRepo = DefaultMeasuringPointRepositoryFactory.createDefaultRepository(resSet);
        resSet.createResource(URI.createURI((String)"model-gen/generated.measuringpoint")).getContents().add((Object)measuringPointRepo);
        resSet.createResource(URI.createURI((String)"model-gen/generated.monitorrepository")).getContents().add((Object)DefaultMonitorRepositoryFactory.createDefaultMonitorRepository(measuringPointRepo));
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return "Default Monitor Repository Completion";
    }

    @Override
    public int compareTo(IJob o) {
        return 1;
    }
}

