/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.modelobserver;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationPackage;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.runtimestate.AssemblyAllocationManager;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.scopes.SimulationRuntimeScope;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

@SimulationRuntimeScope
public class AllocationLookupSyncer
implements IModelObserver {
    private static final Logger LOGGER = Logger.getLogger(AllocationLookupSyncer.class);
    private final EntityReferenceFactory<ResourceContainer> resourceContainerReferenceFactory;
    private final AssemblyAllocationManager allocationManager;
    private PCMResourceSetPartition globalPartition;

    @Inject
    public AllocationLookupSyncer(EntityReferenceFactory<ResourceContainer> resourceContainerReferenceFactory, @PCMPartitionManager.Global PCMResourceSetPartition globalPartition, AssemblyAllocationManager allocationManager) {
        this.resourceContainerReferenceFactory = resourceContainerReferenceFactory;
        this.globalPartition = globalPartition;
        this.allocationManager = allocationManager;
    }

    @Override
    public void initialize() {
        Allocation allocation = this.globalPartition.getAllocation();
        allocation.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                AllocationLookupSyncer.this.handleNotification(notification);
                super.notifyChanged(notification);
            }
        });
        this.addInitialAllocations(allocation);
    }

    protected void handleNotification(Notification msg) {
        switch (msg.getEventType()) {
            case 1: 
            case 3: 
            case 5: {
                this.checkAndAddAllocationContextFromNotification(msg);
                break;
            }
            case 4: 
            case 6: {
                this.checkAndRemoveAllocationContextFromNotification(msg);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The event type %d is not supported for changes of feature %s by %s", msg.getEventType(), msg.getFeature().toString(), this.getClass().getName()));
            }
        }
    }

    protected void addInitialAllocations(Allocation allocation) {
        allocation.getAllocationContexts_Allocation().forEach(this::doAddAllocationContext);
    }

    protected void addAssemblyAllocation(AssemblyContext ctx, System system, List<AssemblyContext> ctxHierarchy, EntityReference<ResourceContainer> container) {
        List<AssemblyContext> baseHierarchy;
        if (ctxHierarchy.isEmpty()) {
            baseHierarchy = this.determineBaseAssemblyPath(ctx, system);
        } else {
            baseHierarchy = new LinkedList<AssemblyContext>(ctxHierarchy);
            baseHierarchy.add(ctx);
        }
        this.allocationManager.allocateAssembly(new FQComponentID(baseHierarchy).getFQIDString(), container);
        RepositoryComponent component = ctx.getEncapsulatedComponent__AssemblyContext();
        if (component instanceof ComposedStructure) {
            ComposedStructure composite = (ComposedStructure)component;
            for (AssemblyContext compCtx : composite.getAssemblyContexts__ComposedStructure()) {
                this.addAssemblyAllocation(compCtx, system, baseHierarchy, container);
            }
        }
    }

    protected List<AssemblyContext> determineBaseAssemblyPath(AssemblyContext ctx, System system) {
        ComposedStructure parentStructure = ctx.getParentStructure__AssemblyContext();
        if (parentStructure instanceof System) {
            return Collections.singletonList(ctx);
        }
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        system.getAssemblyContexts__ComposedStructure().forEach(arg_0 -> this.lambda$1(system, (Graph)graph, arg_0));
        AllDirectedPaths pathLookup = new AllDirectedPaths((Graph)graph);
        List paths = pathLookup.getAllPaths((Object)system, (Object)ctx, false, Integer.valueOf(100));
        if (paths.size() > 1) {
            LOGGER.error((Object)"Ambiguous assembly allocation. The following paths exist:");
            for (GraphPath path : paths) {
                String pathStr = path.getVertexList().stream().map(Identifier::getId).collect(Collectors.joining("->"));
                LOGGER.error((Object)("Alternative: " + pathStr));
            }
            throw new IllegalStateException("Cannot determine unique path to nested assembly context " + ctx.getId());
        }
        if (paths.isEmpty()) {
            throw new IllegalStateException("Could not determine any path from the system to the nested assembly context " + ctx.getId());
        }
        List vertexList = ((GraphPath)paths.get(0)).getVertexList();
        return vertexList.subList(1, vertexList.size());
    }

    protected void appendAssemblyContextRecursively(Entity container, AssemblyContext context, Graph<Entity, ?> graph) {
        graph.addVertex((Object)container);
        graph.addVertex((Object)context);
        graph.addEdge((Object)container, (Object)context);
        if (context.getEncapsulatedComponent__AssemblyContext() instanceof ComposedStructure) {
            ((ComposedStructure)context.getEncapsulatedComponent__AssemblyContext()).getAssemblyContexts__ComposedStructure().forEach(ctx -> this.appendAssemblyContextRecursively((Entity)context, (AssemblyContext)ctx, graph));
        }
    }

    protected void removeAssemblyAllocation(AssemblyContext ctx, List<AssemblyContext> ctxHierarchy) {
        List<AssemblyContext> hierarchy = ctxHierarchy;
        if (ctxHierarchy.isEmpty()) {
            this.allocationManager.deallocateAssembly(ctx.getId());
        } else {
            LinkedList<AssemblyContext> newHierarchy = new LinkedList<AssemblyContext>(ctxHierarchy);
            newHierarchy.push(ctx);
            this.allocationManager.deallocateAssembly(new FQComponentID(newHierarchy).getFQIDString());
            hierarchy = newHierarchy;
        }
        if (ctx.getEncapsulatedComponent__AssemblyContext() instanceof CompositeComponent) {
            CompositeComponent composite = (CompositeComponent)ctx;
            for (AssemblyContext compCtx : composite.getAssemblyContexts__ComposedStructure()) {
                this.removeAssemblyAllocation(compCtx, hierarchy);
            }
        }
    }

    private void processNotification(Notification notification, Function<Notification, Object> extractor, Consumer<AllocationContext> processor) {
        assert (notification.getFeature() == AllocationPackage.Literals.ALLOCATION__ALLOCATION_CONTEXTS_ALLOCATION);
        Object feature = notification.getNewValue();
        if (feature instanceof Collection) {
            ((Collection)feature).forEach(processor);
        } else {
            this.doAddAllocationContext((AllocationContext)feature);
        }
    }

    private void doAddAllocationContext(AllocationContext ctx) {
        if (ctx.getAssemblyContext_AllocationContext() != null) {
            this.addAssemblyAllocation(ctx.getAssemblyContext_AllocationContext(), ctx.getAllocation_AllocationContext().getSystem_Allocation(), Collections.emptyList(), this.resourceContainerReferenceFactory.createCached(ctx.getResourceContainer_AllocationContext()));
        }
    }

    private void doRemoveAllocationContext(AllocationContext ctx) {
        if (ctx.getAssemblyContext_AllocationContext() != null) {
            this.removeAssemblyAllocation(ctx.getAssemblyContext_AllocationContext(), Collections.emptyList());
        }
    }

    private void checkAndAddAllocationContextFromNotification(Notification notification) {
        if (notification.getFeature() == AllocationPackage.Literals.ALLOCATION__ALLOCATION_CONTEXTS_ALLOCATION) {
            this.processNotification(notification, Notification::getNewValue, this::doAddAllocationContext);
        }
    }

    private void checkAndRemoveAllocationContextFromNotification(Notification notification) {
        if (notification.getFeature() == AllocationPackage.Literals.ALLOCATION__ALLOCATION_CONTEXTS_ALLOCATION) {
            this.processNotification(notification, Notification::getOldValue, this::doRemoveAllocationContext);
        }
    }

    private /* synthetic */ void lambda$1(System system, Graph graph, AssemblyContext c) {
        this.appendAssemblyContextRecursively((Entity)system, c, graph);
    }
}

