/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurationLoader;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationEngine;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class ReconfigurationProcess
extends SimuComSimProcess {
    private EObject monitoredElement;
    private final Iterable<IReconfigurationEngine> reconfigurators;
    private final List<Notification> currentReconfigNotifications;
    private final IResourceTableManager resourceTableManager;
    private volatile boolean terminationRequested = false;
    private EList<ModelTransformation<? extends Object>> transformations;
    private final IReconfigurationListener reconfigurationEventDispatcher;
    private final ISimulationTimeProvider simTimeProvider;

    @AssistedInject
    protected ReconfigurationProcess(SimuComModel model, Set<IReconfigurationEngine> reconfigurators, Set<AbstractReconfigurationLoader> reconfigurationLoaders, SimuLizarWorkflowConfiguration configuration, IReconfigurationListener reconfigurationEventDispatcher, IResourceTableManager resourceTableManager, ISimulationTimeProvider simTimeProvider) {
        super(model, "Reconfiguration Process", resourceTableManager);
        this.simTimeProvider = simTimeProvider;
        this.reconfigurationEventDispatcher = Objects.requireNonNull(reconfigurationEventDispatcher, "EventDispatcher must not be null");
        this.reconfigurators = Objects.requireNonNull(reconfigurators, "reconfigurators must not be null");
        this.currentReconfigNotifications = new ArrayList<Notification>();
        this.transformations = new BasicEList();
        this.resourceTableManager = resourceTableManager;
        reconfigurationLoaders.forEach(l -> this.transformations.addAll(l.getTransformations()));
    }

    public void appendReconfigurationNotification(Notification notification) {
        if (notification != null) {
            this.currentReconfigNotifications.add(notification);
        }
    }

    private void fireBeginReconfigurationEvent(BeginReconfigurationEvent event) {
        this.reconfigurationEventDispatcher.beginReconfigurationEvent(event);
    }

    private void fireEndReconfigurationEvent(EndReconfigurationEvent event) {
        this.reconfigurationEventDispatcher.endReconfigurationEvent(event);
    }

    private void fireReconfigurationExecutedEvent(BeginReconfigurationEvent beginEvent, EndReconfigurationEvent endEvent) {
        this.reconfigurationEventDispatcher.reconfigurationExecuted(new ReconfigurationExecutedEvent(beginEvent, endEvent, this.currentReconfigNotifications));
    }

    private void setMonitoredElement(EObject monitoredElement) {
        this.monitoredElement = monitoredElement;
    }

    private EObject getMonitoredElement() {
        return this.monitoredElement;
    }

    private void clearNotifications() {
        this.currentReconfigNotifications.clear();
    }

    public void activate() {
        throw new UnsupportedOperationException("The reconfiguration process is not supposed to be activated manually.Use executeReconfigurations(EObject) instead.");
    }

    public void reschedule(double d) {
        throw new UnsupportedOperationException("The reconfiguration process is not supposed to be scheduled manually.Use executeReconfigurations(EObject) instead.");
    }

    boolean isTerminationRequested() {
        return this.terminationRequested;
    }

    void requestTermination() {
        if (!this.terminationRequested) {
            this.terminationRequested = true;
        }
    }

    void executeReconfigurations(EObject monitoredElement) {
        if (this.isScheduled()) {
            throw new IllegalStateException("Reconfigurations are already taking place.");
        }
        if (this.isFinished()) {
            throw new IllegalStateException("Reconfiguration process has already terminated.");
        }
        this.setMonitoredElement(Objects.requireNonNull(monitoredElement, "Monitored element must not be null."));
        this.scheduleAt(0.0);
    }

    private Consumer<IReconfigurationEngine> doReconfiguration(double currentSimulationTime, EObject monitoredElement) {
        return r -> {
            BeginReconfigurationEvent beginReconfigurationEvent = new BeginReconfigurationEvent(currentSimulationTime);
            this.fireBeginReconfigurationEvent(beginReconfigurationEvent);
            HashMap<String, Object> configParams = new HashMap<String, Object>();
            boolean reconfigResult = r.runCheck((List<? extends ModelTransformation<? extends Object>>)this.transformations, monitoredElement, this.resourceTableManager, (Map<String, Object>)configParams);
            EndReconfigurationEvent endReconfigurationEvent = new EndReconfigurationEvent(EventResult.fromBoolean(reconfigResult), this.simTimeProvider.getCurrentSimulationTime());
            this.fireEndReconfigurationEvent(endReconfigurationEvent);
            if (reconfigResult) {
                LOGGER.debug((Object)"Successfully executed reconfiguration.");
                this.fireReconfigurationExecutedEvent(beginReconfigurationEvent, endReconfigurationEvent);
            }
            this.clearNotifications();
        };
    }

    protected void internalLifeCycle() {
        while (!this.isTerminationRequested()) {
            EObject monitoredElement = this.getMonitoredElement();
            if (monitoredElement == null) continue;
            this.reconfigurators.forEach(this.doReconfiguration(this.simTimeProvider.getCurrentSimulationTime(), monitoredElement));
            this.passivate();
        }
    }
}

