/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.runtimemeasurement.util.RuntimeMeasurementSwitch;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcess;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcessFactory;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

public class Reconfigurator
extends AbstractObservable<IReconfigurationListener>
implements IModelObserver {
    private static final Logger LOGGER = Logger.getLogger(Reconfigurator.class);
    private final Adapter runtimeMeasurementListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Reconfigurator.this.checkAndExecuteReconfigurations(notification);
        }
    };
    private RuntimeMeasurementModel runtimeMeasurementModel;
    private ReconfigurationProcess reconfigurationProcess;
    private double lastReconfigurationTime = 0.0;
    private final ISimulationTimeProvider simTimeProvider;
    private final ReconfigurationProcessFactory processFactory;
    private final PCMResourceSetPartition partition;
    private static final RuntimeMeasurementSwitch<MeasuringPoint> MONITORED_ELEMENT_RETRIEVER = new RuntimeMeasurementSwitch<MeasuringPoint>(){

        public MeasuringPoint caseRuntimeMeasurement(RuntimeMeasurement object) {
            return object.getMeasuringPoint();
        }
    };

    public Reconfigurator(@PCMPartitionManager.Global PCMResourceSetPartition partition, ReconfigurationProcessFactory processFactory, ISimulationTimeProvider simTimeProvider) {
        this.partition = partition;
        this.processFactory = processFactory;
        this.simTimeProvider = simTimeProvider;
    }

    @Override
    public void initialize() {
        List models = this.partition.getElement(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
        if (models.size() != 1) {
            if (models.size() > 1) {
                throw new IllegalStateException("There is more than one Runtime Measurements Model in the global PCM Partition. This is not supported.");
            }
            LOGGER.warn((Object)"No runtime measurements model found. Deactivating the reconfigurator");
        } else {
            this.runtimeMeasurementModel = (RuntimeMeasurementModel)models.get(0);
            this.runtimeMeasurementModel.eAdapters().add((Object)this.runtimeMeasurementListener);
            ((IReconfigurationListener)this.getEventDispatcher()).initialize();
        }
    }

    @Override
    public void unregister() {
        if (this.runtimeMeasurementModel != null) {
            this.runtimeMeasurementModel.eAdapters().remove((Object)this.runtimeMeasurementListener);
        }
        if (this.reconfigurationProcess != null) {
            this.reconfigurationProcess.requestTermination();
        }
        this.removeAllObserver();
    }

    protected void checkAndExecuteReconfigurations(Notification notification) {
        EObject monitoredElement = this.getMonitoredElement(notification);
        if (this.isNotificationNewMeasurement(monitoredElement) && this.simTimeProvider.getCurrentSimulationTime() > this.lastReconfigurationTime && (this.reconfigurationProcess == null || !this.reconfigurationProcess.isScheduled())) {
            if (this.reconfigurationProcess == null) {
                this.reconfigurationProcess = this.processFactory.create();
            }
            this.reconfigurationProcess.executeReconfigurations((EObject)this.runtimeMeasurementModel);
            this.lastReconfigurationTime = this.simTimeProvider.getCurrentSimulationTime();
        }
    }

    private boolean isNotificationNewMeasurement(EObject monitoredElement) {
        return monitoredElement != null;
    }

    void fireReconfigurationEvent(EndReconfigurationEvent endReconfigurationEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).endReconfigurationEvent(endReconfigurationEvent);
    }

    void fireReconfigurationEvent(BeginReconfigurationEvent beginReconfigurationEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).beginReconfigurationEvent(beginReconfigurationEvent);
    }

    void fireReconfigurationEvent(ReconfigurationExecutedEvent reconfigurationExecutedEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).reconfigurationExecuted(reconfigurationExecutedEvent);
    }

    protected EObject getMonitoredElement(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                return (EObject)MONITORED_ELEMENT_RETRIEVER.doSwitch((EObject)notification.getNewValue());
            }
            case 4: {
                return null;
            }
            case 8: {
                return null;
            }
            case 1: {
                return (EObject)MONITORED_ELEMENT_RETRIEVER.doSwitch((EObject)notification.getNotifier());
            }
        }
        LOGGER.warn((Object)("Unsupported RuntimeMeasurement Notification: " + notification));
        return null;
    }

    public ReconfigurationProcess getReconfigurationProcess() {
        return this.reconfigurationProcess;
    }
}

