/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.palladiosimulator.simulizar.interpreter.preinterpretation.PreInterpretationBehaviorContainer;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityManager;
import org.palladiosimulator.simulizar.scopes.SimulationRuntimeScope;

@SimulationRuntimeScope
public class PreInterpretationBehaviorManager
implements RuntimeStateEntityManager {
    private final Map<String, PreInterpretationBehaviorContainer> containerIdStorage = new HashMap<String, PreInterpretationBehaviorContainer>();
    private final Map<EClass, PreInterpretationBehaviorContainer> containerTypeStorage = new HashMap<EClass, PreInterpretationBehaviorContainer>();
    private final InterpreterResultMerger merger;

    @Inject
    public PreInterpretationBehaviorManager(InterpreterResultMerger merger) {
        this.merger = merger;
    }

    public PreInterpretationBehaviorContainer getContainerForEntity(String id) {
        this.containerIdStorage.putIfAbsent(id, new PreInterpretationBehaviorContainer(this.merger));
        return this.containerIdStorage.get(id);
    }

    public PreInterpretationBehaviorContainer getContainerForEntity(EClass object) {
        this.containerTypeStorage.putIfAbsent(object, new PreInterpretationBehaviorContainer(this.merger));
        return this.containerTypeStorage.get(object);
    }

    public boolean hasContainerAlreadyBeenRegisteredForEntity(String id) {
        return this.containerIdStorage.containsKey(id);
    }

    public boolean hasContainerAlreadyBeenRegisteredForEntity(EClass object) {
        return this.containerTypeStorage.containsKey(object);
    }

    @Override
    public void cleanup() {
        this.containerIdStorage.clear();
    }
}

