/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.IWaitingProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.SimSimpleFairPassiveResource;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.legacy.CalculatorFactoryFacade;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedComponentInstance;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

public class SimulatedBasicComponentInstance
extends SimulatedComponentInstance {
    private final Map<String, IPassiveResource> passiveResourcesMap = new HashMap<String, IPassiveResource>();

    @AssistedInject
    public SimulatedBasicComponentInstance(@Assisted InterpreterDefaultContext context, @Assisted FQComponentID fqID, @Assisted List<PassiveResource> passiveResources, SimuComModel simuComModel, @PCMPartitionManager.Global PCMResourceSetPartition partition, CalculatorFactoryFacade calcFactory) {
        super(fqID.getFQIDString());
        AssemblyContext myAssCtx = fqID.getAssembyContextPath().get(fqID.getAssembyContextPath().size() - 1);
        for (PassiveResource passiveResource : passiveResources) {
            long initialCount = (Long)StackContext.evaluateStatic((String)passiveResource.getCapacity_PassiveResource().getSpecification(), Long.class, (SimulatedStackframe)context.getStack().currentStackFrame());
            SimSimpleFairPassiveResource simulatedResource = new SimSimpleFairPassiveResource(passiveResource, myAssCtx, (SchedulerModel)simuComModel, Long.valueOf(initialCount));
            this.passiveResourcesMap.put(passiveResource.getId(), (IPassiveResource)simulatedResource);
            partition.getElement(MonitorRepositoryPackage.eINSTANCE.getMonitorRepository()).forEach(arg_0 -> this.lambda$0(passiveResource, calcFactory, (IPassiveResource)simulatedResource, arg_0));
        }
    }

    private boolean isMonitored(MeasurementSpecification measurementSpecification) {
        return measurementSpecification != null;
    }

    public void acquirePassiveResource(PassiveResource passiveResource, InterpreterDefaultContext context, boolean timeout, double timeoutValue) {
        this.checkAcquireReleasePrecondition(passiveResource);
        this.passiveResourcesMap.get(passiveResource.getId()).acquire((ISchedulableProcess)context.getThread(), 1L, timeout, timeoutValue);
    }

    public void releasePassiveResource(PassiveResource passiveResource, InterpreterDefaultContext context) {
        this.checkAcquireReleasePrecondition(passiveResource);
        this.passiveResourcesMap.get(passiveResource.getId()).release((ISchedulableProcess)context.getThread(), 1L);
    }

    public long getAvailablePassiveResource(PassiveResource passiveResource, InterpreterDefaultContext context) {
        this.checkAcquireReleasePrecondition(passiveResource);
        return this.passiveResourcesMap.get(passiveResource.getId()).getAvailable();
    }

    private void checkAcquireReleasePrecondition(PassiveResource passiveResource) {
        if (passiveResource == null || !this.passiveResourcesMap.containsKey(passiveResource.getId())) {
            throw new IllegalArgumentException("Illegal passive resource for this basic component instance passed");
        }
    }

    @Override
    public void cleanUp() {
        this.passiveResourcesMap.values().stream().map(IPassiveResource::getWaitingProcesses).flatMap(Collection::stream).map(IWaitingProcess::getProcess).forEach(ISchedulableProcess::activate);
        super.cleanUp();
    }

    private /* synthetic */ void lambda$0(PassiveResource passiveResource, CalculatorFactoryFacade calculatorFactoryFacade, IPassiveResource iPassiveResource, MonitorRepository monitorRepo) {
        MeasurementSpecification measurementSpecification = MonitorRepositoryUtil.isMonitored(monitorRepo, (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC);
        if (this.isMonitored(measurementSpecification)) {
            calculatorFactoryFacade.setupPassiveResourceStateCalculator(iPassiveResource);
        }
        if (this.isMonitored(measurementSpecification = MonitorRepositoryUtil.isMonitored(monitorRepo, (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC))) {
            calculatorFactoryFacade.setupWaitingTimeCalculator(iPassiveResource);
        }
        if (this.isMonitored(measurementSpecification = MonitorRepositoryUtil.isMonitored(monitorRepo, (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC))) {
            calculatorFactoryFacade.setupHoldTimeCalculator(iPassiveResource);
        }
    }
}

