/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class TransitionDeterminer {
    protected static final Logger LOGGER = Logger.getLogger((String)TransitionDeterminer.class.getName());
    private final SimuComConfig config;
    private final InterpreterDefaultContext context;

    public TransitionDeterminer(InterpreterDefaultContext context) {
        this.config = context.getModel().getConfiguration();
        this.context = context;
    }

    private boolean conditionHolds(PCMRandomVariable condition) {
        return (Boolean)StackContext.evaluateStatic((String)condition.getSpecification(), Boolean.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
    }

    protected List<Double> createSummedProbabilityList(List<Double> branchProbabilities) {
        double currentSum = 0.0;
        ArrayList<Double> summedProbabilityList = new ArrayList<Double>();
        for (Double probability : branchProbabilities) {
            summedProbabilityList.add(currentSum += probability.doubleValue());
        }
        return summedProbabilityList;
    }

    public BranchTransition determineBranchTransition(EList<BranchTransition> branchTransitions) {
        List<Double> summedProbabilityList = this.createSummedProbabilityList(this.extractProbabiltiesUsageModel(branchTransitions));
        int transitionIndex = this.getRandomIndex(summedProbabilityList, this.config);
        BranchTransition branchTransition = (BranchTransition)branchTransitions.get(transitionIndex);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Chosen branch transition " + transitionIndex + " " + branchTransition));
        }
        return branchTransition;
    }

    private GuardedBranchTransition determineGuardedBranchTransition(EList<AbstractBranchTransition> guardedBranchTransitions) {
        int i = 0;
        GuardedBranchTransition branchTransition = null;
        for (AbstractBranchTransition abstractBranchTransition : guardedBranchTransitions) {
            GuardedBranchTransition guardedBranchTransition = (GuardedBranchTransition)abstractBranchTransition;
            PCMRandomVariable condition = guardedBranchTransition.getBranchCondition_GuardedBranchTransition();
            if (this.conditionHolds(condition)) {
                branchTransition = (GuardedBranchTransition)guardedBranchTransitions.get(i);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("Conditions holds for branch transition " + i + " " + branchTransition));
                break;
            }
            ++i;
        }
        return branchTransition;
    }

    public ProbabilisticBranchTransition determineProbabilisticBranchTransition(EList<AbstractBranchTransition> probabilisticBranchTransitions) {
        List<Double> summedProbabilityList = this.createSummedProbabilityList(this.extractProbabiltiesRDSEFF(probabilisticBranchTransitions));
        int transitionIndex = this.getRandomIndex(summedProbabilityList, this.config);
        ProbabilisticBranchTransition branchTransition = (ProbabilisticBranchTransition)probabilisticBranchTransitions.get(transitionIndex);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Chosen branch transition " + transitionIndex + " " + branchTransition));
        }
        return branchTransition;
    }

    public AbstractBranchTransition determineTransition(EList<AbstractBranchTransition> abstractBranchTransitions) {
        ProbabilisticBranchTransition branchTransition = null;
        if (abstractBranchTransitions.get(0) instanceof ProbabilisticBranchTransition) {
            LOGGER.debug((Object)"Found ProbabilisticBranchTransitions");
            branchTransition = this.determineProbabilisticBranchTransition(abstractBranchTransitions);
        } else {
            LOGGER.debug((Object)"Found GuardedBranchTransitions");
            branchTransition = this.determineGuardedBranchTransition(abstractBranchTransitions);
        }
        return branchTransition;
    }

    protected List<Double> extractProbabiltiesRDSEFF(EList<AbstractBranchTransition> probabilisticBranchTransitions) {
        ArrayList<Double> probabilityList = new ArrayList<Double>();
        for (AbstractBranchTransition probabilisticBranchTransition : probabilisticBranchTransitions) {
            probabilityList.add(((ProbabilisticBranchTransition)probabilisticBranchTransition).getBranchProbability());
        }
        return probabilityList;
    }

    protected List<Double> extractProbabiltiesUsageModel(EList<BranchTransition> branchTransitions) {
        ArrayList<Double> probabilityList = new ArrayList<Double>();
        for (BranchTransition branchTransition : branchTransitions) {
            probabilityList.add(branchTransition.getBranchProbability());
        }
        return probabilityList;
    }

    private int getRandomIndex(List<Double> summedProbabilityList, SimuComConfig simuComConfig) {
        if (summedProbabilityList.size() == 0) {
            return -1;
        }
        double lastSum = summedProbabilityList.get(summedProbabilityList.size() - 1);
        double randomNumer = simuComConfig.getRandomGenerator().random();
        int i = 0;
        for (Double sum : summedProbabilityList) {
            if (lastSum * randomNumer < sum) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

