/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability;

import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;

public class MarkovNetworkInducedFailureType
extends MarkovFailureType {
    private static String NETWORK_ID = "Network-induced failure";
    private static String NETWORK_NAME = "Network-induced failure";
    private String commLinkResourceTypeId = "";
    private String commLinkResourceTypeName = "";
    private String linkingResourceId = "";
    private String linkingResourceName = "";

    public static MarkovNetworkInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, CommunicationLinkResourceType commLinkResourceType, Signature signature, Role role, Interface iface) {
        return new MarkovNetworkInducedFailureType(evaluationType, commLinkResourceType.getId(), commLinkResourceType.getEntityName(), signature.getId(), signature.getEntityName(), role.getId(), role.getEntityName(), iface.getId(), iface.getEntityName());
    }

    public static MarkovNetworkInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, String commLinkResourceTypeId, String signatureId, String systemRequiredRoleId) {
        return new MarkovNetworkInducedFailureType(evaluationType, commLinkResourceTypeId, "", signatureId, "", systemRequiredRoleId, "", "", "");
    }

    public static MarkovNetworkInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, LinkingResource linkingResource, CommunicationLinkResourceType commLinkResourceType) {
        return new MarkovNetworkInducedFailureType(evaluationType, linkingResource.getId(), linkingResource.getEntityName(), commLinkResourceType.getId(), commLinkResourceType.getEntityName());
    }

    public static MarkovNetworkInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, String linkingResourceId, String commLinkResourceTypeId) {
        return new MarkovNetworkInducedFailureType(evaluationType, linkingResourceId, "", commLinkResourceTypeId, "");
    }

    private MarkovNetworkInducedFailureType(MarkovEvaluationType evaluationType, String linkingResourceId, String linkingResourceName, String commLinkResourceTypeId, String commLinkResourceTypeName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(linkingResourceId) + "/" + commLinkResourceTypeId;
                this.name = String.valueOf(linkingResourceName) + "/" + commLinkResourceTypeName + " (system-internal network-induced failure)";
                break;
            }
            case TYPES: {
                this.id = commLinkResourceTypeId;
                this.name = String.valueOf(commLinkResourceTypeName) + " (network-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = NETWORK_ID;
                this.name = NETWORK_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.linkingResourceId = linkingResourceId;
        this.linkingResourceName = linkingResourceName;
        this.commLinkResourceTypeId = commLinkResourceTypeId;
        this.commLinkResourceTypeName = commLinkResourceTypeName;
        this.systemExternal = false;
    }

    private MarkovNetworkInducedFailureType(MarkovEvaluationType evaluationType, String commLinkResourceTypeId, String commLinkResourceTypeName, String signatureId, String signatureName, String systemRequiredRoleId, String systemRequiredRoleName, String interfaceId, String interfaceName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(systemRequiredRoleId) + "/" + signatureId + "/" + commLinkResourceTypeId;
                this.name = String.valueOf(systemRequiredRoleName) + "/" + signatureName + "/" + commLinkResourceTypeName + " (system-external network-induced failure)";
                break;
            }
            case TYPES: {
                this.id = commLinkResourceTypeId;
                this.name = String.valueOf(commLinkResourceTypeName) + " (network-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = NETWORK_ID;
                this.name = NETWORK_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.commLinkResourceTypeId = commLinkResourceTypeId;
        this.commLinkResourceTypeName = commLinkResourceTypeName;
        this.signatureId = signatureId;
        this.signatureName = signatureName;
        this.roleId = systemRequiredRoleId;
        this.roleName = systemRequiredRoleName;
        this.interfaceId = interfaceId;
        this.interfaceName = interfaceName;
        this.commLinkResourceTypeId = commLinkResourceTypeId;
        this.systemExternal = true;
    }

    public String getCommLinkResourceTypeId() {
        return this.commLinkResourceTypeId;
    }

    public String getCommLinkResourceTypeName() {
        return this.commLinkResourceTypeName;
    }

    public String getLinkingResourceId() {
        return this.linkingResourceId;
    }

    public String getLinkingResourceName() {
        return this.linkingResourceName;
    }
}

