/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.cost.modelobserver;

import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.cost.modelobserver.AggregatedContainerCostProbe;
import org.palladiosimulator.cost.modelobserver.ContainerCostProbe;
import org.palladiosimulator.cost.modelobserver.PeriodicallyTriggeredContainerEntity;
import org.palladiosimulator.cost.modelobserver.PeriodicallyTriggeredCostModelEntity;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.mdsdprofiles.notifier.MDSDProfilesNotifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.simulizar.modelobserver.AbstractResourceEnvironmentObserver;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

public class ResourceEnvironmentCostObserver
extends AbstractResourceEnvironmentObserver {
    private final HashMap<String, PeriodicallyTriggeredContainerEntity> periodicallyTriggeredContainerEntities = new HashMap();
    private final PeriodicallyTriggeredCostModelEntity.Factory costModelEntityFactory;
    private final PeriodicallyTriggeredContainerEntity.Factory containerEntityFactory;
    private final IGenericCalculatorFactory calculatorFactory;
    private final ISimulationControl simControl;

    @Inject
    public ResourceEnvironmentCostObserver(@PCMPartitionManager.Global PCMResourceSetPartition globalPCMInstance, PeriodicallyTriggeredContainerEntity.Factory containerEntityFactory, PeriodicallyTriggeredCostModelEntity.Factory costModelEntityFactory, IGenericCalculatorFactory calculatorFactory, ISimulationControl simControl) {
        super(globalPCMInstance);
        this.containerEntityFactory = containerEntityFactory;
        this.costModelEntityFactory = costModelEntityFactory;
        this.calculatorFactory = calculatorFactory;
        this.simControl = simControl;
    }

    private void removeSimulatedResource(ResourceContainer resourceContainer) {
        PeriodicallyTriggeredContainerEntity triggeredEntity = this.periodicallyTriggeredContainerEntities.get(resourceContainer.getId());
        if (triggeredEntity == null) {
            return;
        }
        triggeredEntity.unschedule();
        this.periodicallyTriggeredContainerEntities.remove(resourceContainer.getId());
    }

    private void initPeriodicCostCalculator(ResourceContainer resourceContainer) {
        if (!StereotypeAPI.isStereotypeApplied((EObject)resourceContainer, (String)"Price")) {
            return;
        }
        this.periodicallyTriggeredContainerEntities.put(resourceContainer.getId(), this.containerEntityFactory.create(resourceContainer));
    }

    private void initPeriodicCostModelCalculator() {
        this.model.stream().filter(re -> StereotypeAPI.isStereotypeApplied((EObject)re, (String)"CostReport")).forEach(re -> {
            double interval = (Double)StereotypeAPI.getTaggedValue((EObject)re, (String)"interval", (String)"CostReport");
            this.globalPCMInstance.getElement(MonitorRepositoryPackage.Literals.MONITOR_REPOSITORY).forEach(elem -> {
                MonitorRepository monitorRepository = (MonitorRepository)elem;
                for (MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement((MonitorRepository)monitorRepository, (EObject)re)) {
                    String metricID = measurementSpecification.getMetricDescription().getId();
                    if (metricID.equals(MetricDescriptionConstants.COST_OVER_TIME.getId())) {
                        EventProbeList probe = new EventProbeList((MetricDescription)MetricDescriptionConstants.COST_OVER_TIME, (EventProbe)new ContainerCostProbe(this.costModelEntityFactory.create(interval, interval)), Arrays.asList(new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)this.simControl)));
                        this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.COST_OVER_TIME, measurementSpecification.getMonitor().getMeasuringPoint(), DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probe));
                    }
                    if (!metricID.equals(MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME.getId())) continue;
                    EventProbeList aggregatedProbe = new EventProbeList((MetricDescription)MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME, (EventProbe)new AggregatedContainerCostProbe(this.costModelEntityFactory.create(interval, interval)), Arrays.asList(new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)this.simControl)));
                    this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME, measurementSpecification.getMonitor().getMeasuringPoint(), DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)aggregatedProbe));
                }
            });
        });
    }

    public void initialize() {
        super.initialize();
        this.initPeriodicCostModelCalculator();
        this.model.forEach(re -> re.getResourceContainer_ResourceEnvironment().forEach(this::initPeriodicCostCalculator));
    }

    protected void setTaggedValue(Notification notification) {
        MDSDProfilesNotifier.TaggedValueTuple taggedValueTuple = (MDSDProfilesNotifier.TaggedValueTuple)notification.getNewValue();
        if (ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isInstance(notification.getNotifier()) && taggedValueTuple.getStereotypeName().equals("Price") && taggedValueTuple.getTaggedValueName().equals("unit")) {
            this.initPeriodicCostCalculator((ResourceContainer)notification.getNotifier());
        }
    }

    protected void remove(Notification notification) {
        if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_ResourceContainer_ResourceEnvironment()) {
            this.removeSimulatedResource((ResourceContainer)notification.getOldValue());
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_LinkingResources__ResourceEnvironment() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_CommunicationLinkResourceSpecifications_LinkingResource() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_ConnectedResourceContainers_LinkingResource()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Ignoring sync (remove) of linking resources");
            }
        } else {
            this.logDebugInfo(notification);
        }
    }
}

