/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.cdo.debug.variablesview;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import tools.mdsd.cdo.debug.variablesview.CDOObjectFeatureVariable;
import tools.mdsd.cdo.debug.variablesview.CDOObjectStringValue;
import tools.mdsd.cdo.debug.variablesview.LambdaExceptionUtil;
import tools.mdsd.cdo.debug.variablesview.ValueUtil;

public class CDOObjectValue
implements IValue {
    private final IValue realValue;

    public CDOObjectValue(IValue realValue) {
        this.realValue = realValue;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)this.realValue.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.realValue.getReferenceTypeName();
    }

    public String getModelIdentifier() {
        return this.realValue.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.realValue.getDebugTarget();
    }

    public String getValueString() throws DebugException {
        return this.realValue.getValueString();
    }

    public ILaunch getLaunch() {
        return this.realValue.getLaunch();
    }

    public boolean isAllocated() throws DebugException {
        return this.realValue.isAllocated();
    }

    public IVariable[] getVariables() throws DebugException {
        IValue allFeaturesData = ValueUtil.findField(this.realValue, "revision", "classInfo", "eClass", "eAllStructuralFeatures", "data").get().getValue();
        ArrayList<CDOObjectFeatureVariable> result = new ArrayList<CDOObjectFeatureVariable>();
        result.addAll(this.createObjectFeatureVariables(allFeaturesData));
        ValueUtil.findField(this.realValue, "eFlags").map(LambdaExceptionUtil.wrapFn(variable -> new CDOObjectFeatureVariable("eFlags", variable.getValue()))).ifPresent(result::add);
        ValueUtil.findField(this.realValue, "eStorage").map(LambdaExceptionUtil.wrapFn(variable -> new CDOObjectFeatureVariable("eStorage", variable.getValue()))).ifPresent(result::add);
        ValueUtil.findField(this.realValue, "revision", "classInfo", "eClass", "eContainer").map(LambdaExceptionUtil.wrapFn(variable -> new CDOObjectFeatureVariable("eContainer", variable.getValue()))).ifPresent(result::add);
        return result.toArray(new IVariable[0]);
    }

    private List<CDOObjectFeatureVariable> createObjectFeatureVariables(IValue allFeaturesDataValue) throws DebugException {
        IVariable[] allFeatures = allFeaturesDataValue.getVariables();
        return IntStream.range(0, allFeatures.length).mapToObj(LambdaExceptionUtil.wrapIntFn(i -> {
            IVariable variable = allFeatures[i];
            String name = ValueUtil.findField(variable.getValue(), "name").get().getValue().getValueString();
            IValue value = this.getFeatureValue(i);
            return new CDOObjectFeatureVariable(name, value);
        })).collect(Collectors.toList());
    }

    private IValue getFeatureValue(int i) throws DebugException {
        if (ValueUtil.findField(this.realValue, "viewAndState", "state", "name").get().getValue().getValueString().equals("TRANSIENT")) {
            return this.getTransientFeatureValue(i);
        }
        if (this.isPersistentFeature(i)) {
            return this.getPersistentFeatureValue(i);
        }
        return this.getTransientFeatureValue(i);
    }

    private IValue getTransientFeatureValue(int i) throws DebugException {
        IVariable[] transientIndices = ValueUtil.findField(this.realValue, "revision", "classInfo", "transientFeatureIndices").get().getValue().getVariables();
        IVariable[] settings = ValueUtil.findField(this.realValue, "eSettings").get().getValue().getVariables();
        int settingsIndex = Integer.parseInt(transientIndices[i].getValue().getValueString());
        if (settingsIndex < settings.length) {
            return settings[settingsIndex].getValue();
        }
        return new CDOObjectStringValue("null");
    }

    private IValue getPersistentFeatureValue(int i) throws DebugException {
        IVariable[] persistentIndices = ValueUtil.findField(this.realValue, "revision", "classInfo", "persistentFeatureIndices").get().getValue().getVariables();
        IVariable[] revisionValues = this.getRevisionValues();
        int persistentIndex = Integer.parseInt(persistentIndices[i].getValue().getValueString());
        if (persistentIndex < revisionValues.length) {
            return revisionValues[persistentIndex].getValue();
        }
        return new CDOObjectStringValue("UNAVAILABLE");
    }

    private IVariable[] getRevisionValues() throws DebugException {
        try {
            return ValueUtil.findField(this.realValue, "revision", "values").get().getValue().getVariables();
        }
        catch (NoSuchElementException e) {
            return new IVariable[0];
        }
    }

    private boolean isPersistentFeature(int i) throws DebugException {
        IVariable[] persistentIndices = ValueUtil.findField(this.realValue, "revision", "classInfo", "persistentFeatureIndices").get().getValue().getVariables();
        return Integer.parseInt(persistentIndices[i].getValue().getValueString()) > -1;
    }

    public boolean hasVariables() throws DebugException {
        return this.realValue.hasVariables();
    }
}

