/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.gmf.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.yakindu.base.xtext.utils.gmf.routing.EdgeLabelQuery;

public class SetLabelsOffsetOperation {
    private Map<Node, Point> labelsWithNewOffset;
    private PointList oldBendPointsList;
    private PointList newPointList;

    public void setNewPointList(PointList newPointList) {
        this.newPointList = new PointList(newPointList.size());
        int i = 0;
        while (i < newPointList.size()) {
            this.newPointList.addPoint(newPointList.getPoint(i));
            ++i;
        }
    }

    public void setLabelsToUpdate(ConnectionEditPart connectionEditPart, PointList originalPoints) {
        this.oldBendPointsList = originalPoints;
        this.setLabelsToUpdate(connectionEditPart);
    }

    public void setLabelsToUpdate(ConnectionEditPart connectionEditPart) {
        ArrayList<LabelEditPart> labelEditPartsToUpdate = new ArrayList<LabelEditPart>();
        List children = connectionEditPart.getChildren();
        for (Object child : children) {
            Object view;
            if (!(child instanceof LabelEditPart) || !((view = ((LabelEditPart)child).getModel()) instanceof Node)) continue;
            labelEditPartsToUpdate.add((LabelEditPart)child);
        }
        this.computeGMFLabelsOffset(labelEditPartsToUpdate, connectionEditPart);
    }

    private void computeGMFLabelsOffset(List<LabelEditPart> labelEditPartsToUpdate, ConnectionEditPart connectionEditPart) {
        this.labelsWithNewOffset = new HashMap<Node, Point>();
        for (LabelEditPart labelEditPartToUpdate : labelEditPartsToUpdate) {
            this.computeGMFLabelOffset(labelEditPartToUpdate, connectionEditPart);
        }
    }

    private void computeGMFLabelOffset(LabelEditPart labelEditPartToUpdate, ConnectionEditPart connectionEditPart) {
        Point newLabelOffset = null;
        Node labelNodeToUpdate = (Node)labelEditPartToUpdate.getModel();
        if (connectionEditPart.getModel() instanceof Edge) {
            PointList oldBendpoints = this.oldBendPointsList;
            if (oldBendpoints == null) {
                oldBendpoints = connectionEditPart.getConnectionFigure().getPoints();
            }
            boolean isEdgeWithObliqueRoutingStyle = SetLabelsOffsetOperation.isEdgeWithObliqueRoutingStyle((org.eclipse.gef.ConnectionEditPart)connectionEditPart);
            LayoutConstraint layoutConstraint = labelNodeToUpdate.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location point = (Location)layoutConstraint;
                newLabelOffset = new EdgeLabelQuery(oldBendpoints, this.newPointList, isEdgeWithObliqueRoutingStyle, new Point(point.getX(), point.getY()), labelEditPartToUpdate.getFigure().getSize(), labelEditPartToUpdate.getKeyPoint(), false).calculateGMFLabelOffset();
            }
        }
        if (newLabelOffset != null) {
            this.labelsWithNewOffset.put(labelNodeToUpdate, newLabelOffset);
        }
    }

    public static boolean isEdgeWithObliqueRoutingStyle(org.eclipse.gef.ConnectionEditPart part) {
        Edge edge = (Edge)part.getModel();
        ConnectorStyle style = (ConnectorStyle)edge.getStyle(NotationPackage.Literals.CONNECTOR_STYLE);
        if (style != null) {
            return Routing.MANUAL_LITERAL == style.getRouting();
        }
        return false;
    }

    public void updateGMFLabelsOffset() {
        if (this.labelsWithNewOffset != null) {
            Set<Map.Entry<Node, Point>> entries = this.labelsWithNewOffset.entrySet();
            for (Map.Entry<Node, Point> entry : entries) {
                LayoutConstraint layoutConstraint = entry.getKey().getLayoutConstraint();
                if (!(layoutConstraint instanceof Location)) continue;
                Location bounds = (Location)layoutConstraint;
                bounds.setX(entry.getValue().x);
                bounds.setY(entry.getValue().y);
            }
        }
    }
}

