/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.gmf.directedit;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultAntlrTokenToAttributeIdMapper;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.yakindu.base.xtext.utils.gmf.directedit.DummyDocument;

@Singleton
public class StyleRanges {
    @Inject
    private Provider<DocumentTokenSource> tokenSourceProvider;
    @Inject
    private ITextAttributeProvider attributeProvider;
    @Inject
    private DefaultAntlrTokenToAttributeIdMapper tokenTypeMapper;

    public List<StyleRange> getRanges(String expression) {
        ArrayList ranges = Lists.newArrayList();
        DocumentEvent event = new DocumentEvent();
        event.fDocument = new DummyDocument(expression);
        DocumentTokenSource tokenSource = (DocumentTokenSource)this.tokenSourceProvider.get();
        tokenSource.updateStructure(event);
        for (ILexerTokenRegion next : tokenSource.getTokenInfos()) {
            TextAttribute attribute = this.attributeProvider.getAttribute(this.tokenTypeMapper.getId(next.getLexerTokenType()));
            StyleRange range = new StyleRange(next.getOffset(), next.getLength(), attribute.getForeground(), attribute.getBackground());
            range.font = attribute.getFont();
            range.fontStyle = attribute.getStyle();
            ranges.add(range);
        }
        return this.merge(ranges);
    }

    protected List<StyleRange> merge(List<StyleRange> ranges) {
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        for (StyleRange styleRange : ranges) {
            if (result.isEmpty()) {
                result.add(styleRange);
                continue;
            }
            StyleRange lastRange = (StyleRange)result.get(result.size() - 1);
            if (this.equal(lastRange, styleRange)) {
                lastRange.length += styleRange.length;
                continue;
            }
            result.add(styleRange);
        }
        return result;
    }

    protected boolean equal(StyleRange lastRange, StyleRange styleRange) {
        return lastRange.fontStyle == styleRange.fontStyle && Objects.equal((Object)lastRange.background, (Object)styleRange.background) && Objects.equal((Object)lastRange.foreground, (Object)styleRange.foreground);
    }
}

