/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.gmf.directedit;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.yakindu.base.xtext.utils.gmf.directedit.DirectEditManagerEx;
import org.yakindu.base.xtext.utils.gmf.directedit.IXtextAwareEditPart;
import org.yakindu.base.xtext.utils.gmf.viewers.XtextStyledTextCellEditorEx;
import org.yakindu.base.xtext.utils.jface.viewers.context.IXtextFakeContextResourcesProvider;

public class XtextDirectEditManager
extends DirectEditManagerEx {
    private Color proposalPopupBackgroundColor = null;
    private Color proposalPopupForegroundColor = null;
    private boolean committed = false;
    private boolean listenersAttached = true;
    private StringBuffer initialString = new StringBuffer();
    private List<FontDescriptor> cachedFontDescriptors = new ArrayList<FontDescriptor>();
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private Font zoomLevelFont = null;
    private AncestorListener textFigureListener;
    private Class<?> editorType;
    private final Injector injector;
    private final int style;
    private IXtextFakeContextResourcesProvider fakeProvider;
    private static final int LABEL_MIN_WIDTH = 75;

    public XtextDirectEditManager(IXtextAwareEditPart source, Injector injector, int style) {
        this((GraphicalEditPart)source, null, XtextDirectEditManager.getTextCellEditorLocator(source), injector, style);
    }

    public XtextDirectEditManager(IXtextAwareEditPart source, Injector injector, int style, IXtextFakeContextResourcesProvider provider) {
        this((GraphicalEditPart)source, null, XtextDirectEditManager.getTextCellEditorLocator(source), injector, style);
        this.fakeProvider = provider;
    }

    public XtextDirectEditManager(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator, Injector injector, int style) {
        super(source, editorType, locator);
        this.editorType = editorType;
        this.injector = injector;
        this.style = style;
    }

    public static CellEditorLocator getTextCellEditorLocator(final IXtextAwareEditPart source) {
        final ILabelDelegate label = (ILabelDelegate)source.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return new CellEditorLocator(){

                public void relocate(CellEditor celleditor) {
                    org.eclipse.swt.graphics.Rectangle newRect;
                    StyledText text = (StyledText)celleditor.getControl();
                    Rectangle rect = label.getTextBounds().getCopy();
                    if (label.getText().length() <= 0) {
                        rect.setSize(TextUtilities.INSTANCE.getTextExtents("a", text.getFont()));
                        if (label.isTextWrapOn()) {
                            if (label.getTextJustification() == 4) {
                                rect.translate(-rect.width, 0);
                            } else if (label.getTextJustification() == 2) {
                                rect.translate(-rect.width / 2, 0);
                            }
                        }
                    }
                    if (!text.getFont().isDisposed()) {
                        if (label.isTextWrapOn()) {
                            int charHeight = FigureUtilities.getFontMetrics((Font)text.getFont()).getHeight();
                            rect.resize(0, charHeight / 2);
                        } else {
                            rect.setSize(new Dimension(text.computeSize(-1, -1)));
                            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                        }
                    }
                    if (!(newRect = text.computeTrim(rect.x, rect.y, rect.width, rect.height)).equals((Object)text.getBounds())) {
                        text.setBounds(newRect.x, newRect.y, newRect.width, newRect.height);
                    }
                }
            };
        }
        return new CellEditorLocator(){

            public void relocate(CellEditor celleditor) {
                StyledText text = (StyledText)celleditor.getControl();
                Rectangle rect = source.getFigure().getBounds().getCopy();
                rect.width = Math.max(rect.width, 75);
                if (!text.isDisposed() && text.getFont() != null && !text.getFont().isDisposed()) {
                    Dimension fontMetrics = TextUtilities.INSTANCE.getTextExtents("a", text.getFont()).getCopy();
                    double avChar = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.width = (int)Math.ceil((double)rect.width + avChar);
                    source.getFigure().translateToRelative((Translatable)fontMetrics);
                    rect.height = Math.max(rect.height, fontMetrics.height);
                }
                source.getFigure().translateToAbsolute((Translatable)rect);
                if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                    text.setBounds(rect.x, rect.y, rect.width, rect.height);
                }
            }
        };
    }

    @Override
    protected CellEditor createCellEditorOn(Composite composite) {
        XtextStyledTextCellEditorEx editor;
        Composite parent = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 10;
        parent.setLayout((Layout)fillLayout);
        if (this.editorType != null) {
            return super.createCellEditorOn(parent);
        }
        if (this.fakeProvider != null) {
            editor = new XtextStyledTextCellEditorEx(this.style, this.injector, this.fakeProvider);
            editor.create(composite);
        } else {
            editor = new XtextStyledTextCellEditorEx(this.style, this.injector);
            editor.create(composite);
        }
        return editor;
    }

    protected Font getScaledFont(IFigure label) {
        Font scaledFont = label.getFont();
        FontData data = scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, MapModeUtil.getMapMode((IFigure)label).DPtoLP(data.getHeight()));
        label.translateToAbsolute((Translatable)fontSize);
        if (Math.abs(data.getHeight() - fontSize.height) < 2) {
            fontSize.height = data.getHeight();
        }
        try {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            this.cachedFontDescriptors.add(fontDescriptor);
            return this.getResourceManager().createFont(fontDescriptor);
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getScaledFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getScaledFont", (Throwable)e);
            return JFaceResources.getDefaultFont();
        }
    }

    @Override
    protected void initCellEditor() {
        this.committed = false;
        this.setEditText(this.getEditPart().getEditText());
        IFigure label = this.getEditPart().getFigure();
        Assert.isNotNull((Object)label);
        StyledText text = (StyledText)this.getCellEditor().getControl();
        text.setFont(this.getScaledFont(label));
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    @Override
    protected void commit() {
        Control[] children;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell != null && this.getCellEditor().getControl().getShell().equals(activeShell.getParent()) && (children = activeShell.getChildren()).length == 1 && children[0] instanceof Table) {
            this.getCellEditor().getControl().setVisible(true);
            ((XtextStyledTextCellEditorEx)this.getCellEditor()).setDeactivationLock(true);
            return;
        }
        if (this.committed) {
            this.bringDown();
            return;
        }
        this.committed = true;
        super.commit();
    }

    @Override
    protected void bringDown() {
        if (this.proposalPopupForegroundColor != null) {
            this.proposalPopupForegroundColor.dispose();
            this.proposalPopupForegroundColor = null;
        }
        if (this.proposalPopupBackgroundColor != null) {
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupBackgroundColor = null;
        }
        this.eraseFeedback();
        this.initialString = new StringBuffer();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                XtextDirectEditManager.super.bringDown();
            }
        });
        Iterator<FontDescriptor> iter = this.cachedFontDescriptors.iterator();
        while (iter.hasNext()) {
            this.getResourceManager().destroyFont(iter.next());
        }
        this.cachedFontDescriptors.clear();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        IXtextAwareEditPart textEP = this.getEditPart();
        StyledText textControl = (StyledText)cellEditor.getControl();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof TextCellEditorEx) {
            ((TextCellEditorEx)cellEditor).setValueAndProcessEditOccured((Object)toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
        textControl.setSelection(toEdit.length());
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }

    private Font getZoomLevelFont(Font actualFont, Display display) {
        Object zoom = this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoom != null) {
            double zoomLevel = ((ZoomManager)zoom).getZoom();
            if (zoomLevel == 1.0) {
                return actualFont;
            }
            FontData[] fd = new FontData[actualFont.getFontData().length];
            FontData tempFD = null;
            int i = 0;
            while (i < fd.length) {
                tempFD = actualFont.getFontData()[i];
                fd[i] = new FontData(tempFD.getName(), (int)(zoomLevel * (double)tempFD.getHeight()), tempFD.getStyle());
                ++i;
            }
            try {
                FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData[])fd);
                this.cachedFontDescriptors.add(fontDescriptor);
                return this.getResourceManager().createFont(fontDescriptor);
            }
            catch (DeviceResourceException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getZoomLevelFonts", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getZoomLevelFonts", (Throwable)e);
                return actualFont;
            }
        }
        return actualFont;
    }

    @Override
    public void show() {
        super.show();
        IFigure fig = this.getEditPart().getFigure();
        Control control = this.getCellEditor().getControl();
        this.zoomLevelFont = this.getZoomLevelFont(fig.getFont(), control.getDisplay());
        control.setFont(this.zoomLevelFont);
        this.getLocator().relocate(this.getCellEditor());
    }

    public void show(Point location) {
        this.show();
        this.sendClickToCellEditor(location);
    }

    private void sendClickToCellEditor(Point location) {
        this.getCellEditor().getControl().setCapture(true);
        if (this.getCellEditor() != null && this.getCellEditor().getControl().getBounds().contains(location)) {
            this.sendMouseClick(location);
        }
    }

    private void sendMouseClick(final Point location) {
        final Display currDisplay = Display.getCurrent();
        currDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                event.type = 3;
                event.button = 1;
                event.x = location.x;
                event.y = location.y;
                currDisplay.post(event);
                event.type = 4;
                currDisplay.post(event);
            }
        });
    }

    @Override
    protected void hookListeners() {
        super.hookListeners();
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && this.getEditPart().getFigure() instanceof WrappingLabel) {
            this.textFigureListener = new AncestorListener.Stub(){

                public void ancestorMoved(IFigure ancestor) {
                    XtextDirectEditManager.this.getLocator().relocate(XtextDirectEditManager.this.getCellEditor());
                }
            };
            ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).addAncestorListener(this.textFigureListener);
        }
    }

    @Override
    protected void unhookListeners() {
        if (this.listenersAttached) {
            this.listenersAttached = false;
            super.unhookListeners();
            ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
            if (label != null && this.textFigureListener != null) {
                ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).removeAncestorListener(this.textFigureListener);
                this.textFigureListener = null;
            }
        }
    }

    @Override
    protected void setCellEditor(CellEditor editor) {
        super.setCellEditor(editor);
        if (editor != null) {
            this.listenersAttached = true;
        }
    }

    @Override
    public void showFeedback() {
        try {
            this.getEditPart().getRoot();
            super.showFeedback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected IFigure getCellEditorFrame() {
        IFigure cellEditorFrame = super.getCellEditorFrame();
        cellEditorFrame.setBorder((Border)new CompoundBorder((Border)new MarginBorder(new Insets(0, 10, 0, 0)), BORDER_FRAME));
        return cellEditorFrame;
    }

    protected IXtextAwareEditPart getEditPart() {
        return (IXtextAwareEditPart)super.getEditPart();
    }

    protected ResourceManager getResourceManager() {
        return ((DiagramGraphicalViewer)this.getEditPart().getViewer()).getResourceManager();
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        this.copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }
}

