/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.io.Serializable;
import javax.measure.converter.ConversionException;

public abstract class UnitConverter
implements Serializable {
    public static final UnitConverter IDENTITY = new Identity();

    protected UnitConverter() {
    }

    public abstract UnitConverter inverse();

    public abstract double convert(double var1) throws ConversionException;

    public abstract boolean isLinear();

    public boolean equals(Object cvtr) {
        if (!(cvtr instanceof UnitConverter)) {
            return false;
        }
        return this.concatenate(((UnitConverter)cvtr).inverse()) == IDENTITY;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.convert(1.0));
    }

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new Compound(converter, this);
    }

    private static final class Compound
    extends UnitConverter {
        private final UnitConverter _first;
        private final UnitConverter _second;
        private static final long serialVersionUID = 1L;

        private Compound(UnitConverter first, UnitConverter second) {
            this._first = first;
            this._second = second;
        }

        @Override
        public UnitConverter inverse() {
            return new Compound(this._second.inverse(), this._first.inverse());
        }

        @Override
        public double convert(double x) {
            return this._second.convert(this._first.convert(x));
        }

        @Override
        public boolean isLinear() {
            return this._first.isLinear() && this._second.isLinear();
        }
    }

    private static final class Identity
    extends UnitConverter {
        private static final long serialVersionUID = 1L;

        private Identity() {
        }

        @Override
        public UnitConverter inverse() {
            return this;
        }

        @Override
        public double convert(double x) {
            return x;
        }

        @Override
        public boolean isLinear() {
            return true;
        }

        @Override
        public UnitConverter concatenate(UnitConverter converter) {
            return converter;
        }
    }
}

